/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.objectives;

import java.util.ArrayList;
import java.util.Collection;
import tools.refinery.logic.literal.Reduction;
import tools.refinery.store.dse.transition.objectives.CompositeCriterion;
import tools.refinery.store.dse.transition.objectives.Criterion;
import tools.refinery.store.dse.transition.objectives.CriterionCalculator;
import tools.refinery.store.model.Model;
import tools.refinery.store.model.ModelStore;

public final class AndCriterion
extends CompositeCriterion {
    AndCriterion(Collection<? extends Criterion> criteria) {
        super(criteria);
    }

    @Override
    public Reduction getReduction(ModelStore store) {
        for (Criterion criterion : this.getCriteria()) {
            Reduction reduction = criterion.getReduction(store);
            if (reduction == Reduction.ALWAYS_FALSE) {
                return Reduction.ALWAYS_FALSE;
            }
            if (reduction != Reduction.NOT_REDUCIBLE) continue;
            return Reduction.NOT_REDUCIBLE;
        }
        return Reduction.ALWAYS_TRUE;
    }

    @Override
    public CriterionCalculator createCalculator(Model model) {
        ArrayList<CriterionCalculator> calculators = new ArrayList<CriterionCalculator>();
        for (Criterion criterion : this.getCriteria()) {
            Reduction reduction = criterion.getReduction(model.getStore());
            if (reduction == Reduction.ALWAYS_FALSE) {
                return () -> false;
            }
            if (reduction != Reduction.NOT_REDUCIBLE) continue;
            calculators.add(criterion.createCalculator(model));
        }
        return () -> {
            for (CriterionCalculator calculator : calculators) {
                if (calculator.isSatisfied()) continue;
                return false;
            }
            return true;
        };
    }
}

