/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.objectives;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import tools.refinery.store.dse.transition.objectives.AndCriterion;
import tools.refinery.store.dse.transition.objectives.Criterion;
import tools.refinery.store.dse.transition.objectives.OrCriterion;
import tools.refinery.store.model.ModelStoreBuilder;

public abstract sealed class CompositeCriterion
implements Criterion
permits AndCriterion, OrCriterion {
    private final List<Criterion> criteria;

    protected CompositeCriterion(Collection<? extends Criterion> criteria) {
        LinkedHashSet<Criterion> deDuplicatedCriteria = new LinkedHashSet<Criterion>();
        for (Criterion criterion : criteria) {
            if (criterion.getClass() == this.getClass()) {
                List<Criterion> childCriteria = ((CompositeCriterion)criterion).getCriteria();
                deDuplicatedCriteria.addAll(childCriteria);
                continue;
            }
            deDuplicatedCriteria.add(criterion);
        }
        this.criteria = List.copyOf(deDuplicatedCriteria);
    }

    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    @Override
    public void configure(ModelStoreBuilder storeBuilder) {
        for (Criterion criterion : this.criteria) {
            criterion.configure(storeBuilder);
        }
    }
}

