/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.objectives;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import tools.refinery.store.dse.transition.objectives.Objective;
import tools.refinery.store.dse.transition.objectives.ObjectiveCalculator;
import tools.refinery.store.model.Model;
import tools.refinery.store.model.ModelStore;
import tools.refinery.store.model.ModelStoreBuilder;

public class CompositeObjective
implements Objective {
    private final List<Objective> objectives;

    CompositeObjective(Collection<? extends Objective> objectives) {
        ArrayList<Objective> unwrappedObjectives = new ArrayList<Objective>();
        for (Objective objective : objectives) {
            if (objective instanceof CompositeObjective) {
                CompositeObjective compositeObjective = (CompositeObjective)objective;
                unwrappedObjectives.addAll(compositeObjective.getObjectives());
                continue;
            }
            unwrappedObjectives.add(objective);
        }
        this.objectives = Collections.unmodifiableList(unwrappedObjectives);
    }

    public List<Objective> getObjectives() {
        return this.objectives;
    }

    @Override
    public boolean isAlwaysZero(ModelStore store) {
        for (Objective objective : this.objectives) {
            if (objective.isAlwaysZero(store)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ObjectiveCalculator createCalculator(Model model) {
        ArrayList<ObjectiveCalculator> calculators = new ArrayList<ObjectiveCalculator>();
        for (Objective objective : this.objectives) {
            if (objective.isAlwaysZero(model.getStore())) continue;
            calculators.add(objective.createCalculator(model));
        }
        return () -> {
            double value = 0.0;
            for (ObjectiveCalculator calculator : calculators) {
                value += calculator.getValue();
            }
            return value;
        };
    }

    @Override
    public void configure(ModelStoreBuilder storeBuilder) {
        for (Objective objective : this.objectives) {
            objective.configure(storeBuilder);
        }
    }
}

