/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.objectives;

import tools.refinery.logic.dnf.AnyQuery;
import tools.refinery.logic.dnf.Query;
import tools.refinery.logic.dnf.RelationalQuery;
import tools.refinery.logic.literal.Reduction;
import tools.refinery.store.dse.transition.objectives.Objective;
import tools.refinery.store.dse.transition.objectives.ObjectiveCalculator;
import tools.refinery.store.model.Model;
import tools.refinery.store.model.ModelStore;
import tools.refinery.store.model.ModelStoreBuilder;
import tools.refinery.store.query.ModelQueryAdapter;
import tools.refinery.store.query.ModelQueryBuilder;
import tools.refinery.store.query.ModelQueryStoreAdapter;
import tools.refinery.store.query.resultset.ResultSet;

public class CountObjective
implements Objective {
    private final RelationalQuery query;
    private final double weight;

    public CountObjective(RelationalQuery query) {
        this(query, 1.0);
    }

    public CountObjective(RelationalQuery query, double weight) {
        this.query = query;
        this.weight = weight;
    }

    @Override
    public boolean isAlwaysZero(ModelStore store) {
        ModelQueryStoreAdapter queryStore = (ModelQueryStoreAdapter)store.getAdapter(ModelQueryStoreAdapter.class);
        Query canonicalQuery = queryStore.getCanonicalQuery((Query)this.query);
        return canonicalQuery.getDnf().getReduction() == Reduction.ALWAYS_FALSE;
    }

    @Override
    public ObjectiveCalculator createCalculator(Model model) {
        ResultSet resultSet = ((ModelQueryAdapter)model.getAdapter(ModelQueryAdapter.class)).getResultSet((Query)this.query);
        return () -> (double)resultSet.size() * this.weight;
    }

    @Override
    public void configure(ModelStoreBuilder storeBuilder) {
        ((ModelQueryBuilder)storeBuilder.getAdapter(ModelQueryBuilder.class)).query((AnyQuery)this.query);
    }
}

