/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.objectives;

import java.util.ArrayList;
import java.util.Collection;
import tools.refinery.logic.literal.Reduction;
import tools.refinery.store.dse.transition.objectives.CompositeCriterion;
import tools.refinery.store.dse.transition.objectives.Criterion;
import tools.refinery.store.dse.transition.objectives.CriterionCalculator;
import tools.refinery.store.model.Model;
import tools.refinery.store.model.ModelStore;

public final class OrCriterion
extends CompositeCriterion {
    OrCriterion(Collection<? extends Criterion> criteria) {
        super(criteria);
    }

    @Override
    public Reduction getReduction(ModelStore store) {
        for (Criterion criterion : this.getCriteria()) {
            Reduction reduction = criterion.getReduction(store);
            if (reduction == Reduction.ALWAYS_TRUE) {
                return Reduction.ALWAYS_TRUE;
            }
            if (reduction != Reduction.NOT_REDUCIBLE) continue;
            return Reduction.NOT_REDUCIBLE;
        }
        return Reduction.ALWAYS_FALSE;
    }

    @Override
    public CriterionCalculator createCalculator(Model model) {
        ArrayList<CriterionCalculator> calculators = new ArrayList<CriterionCalculator>();
        for (Criterion criterion : this.getCriteria()) {
            Reduction reduction = criterion.getReduction(model.getStore());
            if (reduction == Reduction.ALWAYS_TRUE) {
                return () -> true;
            }
            if (reduction != Reduction.NOT_REDUCIBLE) continue;
            calculators.add(criterion.createCalculator(model));
        }
        return () -> {
            for (CriterionCalculator calculator : calculators) {
                if (!calculator.isSatisfied()) continue;
                return true;
            }
            return false;
        };
    }
}

