/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.objectives;

import tools.refinery.logic.dnf.AnyQuery;
import tools.refinery.logic.literal.Reduction;
import tools.refinery.store.dse.transition.objectives.Criterion;
import tools.refinery.store.dse.transition.objectives.CriterionCalculator;
import tools.refinery.store.model.Model;
import tools.refinery.store.model.ModelStore;
import tools.refinery.store.model.ModelStoreBuilder;
import tools.refinery.store.query.ModelQueryAdapter;
import tools.refinery.store.query.ModelQueryBuilder;
import tools.refinery.store.query.ModelQueryStoreAdapter;
import tools.refinery.store.query.resultset.AnyResultSet;

public class QueryCriterion
implements Criterion {
    protected final boolean satisfiedIfHasMatch;
    protected final AnyQuery query;

    public QueryCriterion(AnyQuery query, boolean satisfiedIfHasMatch) {
        this.query = query;
        this.satisfiedIfHasMatch = satisfiedIfHasMatch;
    }

    @Override
    public Reduction getReduction(ModelStore store) {
        ModelQueryStoreAdapter queryStore = (ModelQueryStoreAdapter)store.getAdapter(ModelQueryStoreAdapter.class);
        AnyQuery canonicalQuery = queryStore.getCanonicalQuery(this.query);
        Reduction reduction = canonicalQuery.getDnf().getReduction();
        if (this.satisfiedIfHasMatch) {
            return reduction;
        }
        return reduction.negate();
    }

    @Override
    public CriterionCalculator createCalculator(Model model) {
        AnyResultSet resultSet = ((ModelQueryAdapter)model.getAdapter(ModelQueryAdapter.class)).getResultSet(this.query);
        if (this.satisfiedIfHasMatch) {
            return () -> resultSet.size() > 0;
        }
        return () -> resultSet.size() == 0;
    }

    @Override
    public void configure(ModelStoreBuilder storeBuilder) {
        Criterion.super.configure(storeBuilder);
        ((ModelQueryBuilder)storeBuilder.getAdapter(ModelQueryBuilder.class)).query(this.query);
    }
}

