/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.objectives;

import tools.refinery.logic.dnf.FunctionalQuery;
import tools.refinery.store.dse.transition.objectives.Objective;
import tools.refinery.store.dse.transition.objectives.ObjectiveCalculator;
import tools.refinery.store.map.Cursor;
import tools.refinery.store.model.Model;
import tools.refinery.store.model.ModelStoreBuilder;
import tools.refinery.store.query.ModelQueryAdapter;
import tools.refinery.store.query.ModelQueryBuilder;
import tools.refinery.store.query.resultset.ResultSet;

public class QueryObjective
implements Objective {
    protected final FunctionalQuery<? extends Number> objectiveFunction;

    public QueryObjective(FunctionalQuery<? extends Number> objectiveFunction) {
        if (objectiveFunction.arity() != 0) {
            throw new IllegalArgumentException("Objective functions must have 0 parameters, got %d instead".formatted(objectiveFunction.arity()));
        }
        this.objectiveFunction = objectiveFunction;
    }

    @Override
    public ObjectiveCalculator createCalculator(Model model) {
        ResultSet resultSet = ((ModelQueryAdapter)model.getAdapter(ModelQueryAdapter.class)).getResultSet(this.objectiveFunction);
        return () -> {
            Cursor cursor = resultSet.getAll();
            if (!cursor.move()) {
                return 0.0;
            }
            return Math.max(((Number)cursor.getValue()).doubleValue(), 0.0);
        };
    }

    @Override
    public void configure(ModelStoreBuilder storeBuilder) {
        ((ModelQueryBuilder)storeBuilder.getAdapter(ModelQueryBuilder.class)).query(this.objectiveFunction);
    }
}

