/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.statespace.internal;

import tools.refinery.store.dse.transition.statespace.internal.ActivationStoreEntry;

public class ActivationStoreBitVectorEntry
extends ActivationStoreEntry {
    final int[] selected;
    private static final int ELEMENT_POSITION = 5;
    private static final int ELEMENT_BITMASK = 31;

    ActivationStoreBitVectorEntry(int numberOfActivations) {
        super(numberOfActivations);
        this.selected = new int[numberOfActivations / 32 + 1];
    }

    @Override
    public int getNumberOfVisitedActivations() {
        int visited = 0;
        for (int i = 0; i < this.selected.length; ++i) {
            visited += Integer.bitCount(this.selected[i]);
        }
        return visited;
    }

    @Override
    public int getAndAddActivationAfter(int index) {
        int position = index;
        do {
            int selectedBit;
            int selectedElement;
            if ((this.selected[selectedElement = position >> 5] & (selectedBit = 1 << (position & 0x1F))) == 0) {
                int n = selectedElement;
                this.selected[n] = this.selected[n] | selectedBit;
                return position;
            }
            if (position < this.numberOfActivations - 1) {
                ++position;
                continue;
            }
            position = 0;
        } while (position != index);
        throw new IllegalArgumentException("There is are no unvisited activations!");
    }
}

