/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.statespace.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import tools.refinery.store.dse.transition.VersionWithObjectiveValue;
import tools.refinery.store.dse.transition.statespace.ActivationStore;
import tools.refinery.store.dse.transition.statespace.internal.ActivationStoreEntry;

public class ActivationStoreImpl
implements ActivationStore {
    final int numberOfTransformations;
    final Consumer<VersionWithObjectiveValue> actionWhenAllActivationVisited;
    final Map<VersionWithObjectiveValue, List<ActivationStoreEntry>> versionToActivations;

    public ActivationStoreImpl(int numberOfTransformations, Consumer<VersionWithObjectiveValue> actionWhenAllActivationVisited) {
        this.numberOfTransformations = numberOfTransformations;
        this.actionWhenAllActivationVisited = actionWhenAllActivationVisited;
        this.versionToActivations = new HashMap<VersionWithObjectiveValue, List<ActivationStoreEntry>>();
    }

    @Override
    public synchronized ActivationStore.VisitResult markNewAsVisited(VersionWithObjectiveValue to, int[] emptyEntrySizes) {
        boolean[] successful = new boolean[]{false};
        List entries = this.versionToActivations.computeIfAbsent(to, x -> {
            successful[0] = true;
            ArrayList<ActivationStoreEntry> result = new ArrayList<ActivationStoreEntry>(emptyEntrySizes.length);
            for (int emptyEntrySize : emptyEntrySizes) {
                result.add(ActivationStoreEntry.create(emptyEntrySize));
            }
            return result;
        });
        boolean hasMore = false;
        for (ActivationStoreEntry entry : entries) {
            if (entry.getNumberOfUnvisitedActivations() <= 0) continue;
            hasMore = true;
            break;
        }
        if (!hasMore) {
            this.actionWhenAllActivationVisited.accept(to);
        }
        return new ActivationStore.VisitResult(successful[0], hasMore, -1, -1);
    }

    public synchronized ActivationStore.VisitResult visitActivation(VersionWithObjectiveValue from, int transformationIndex, int activationIndex) {
        boolean hasMore;
        int activation;
        int transformation;
        boolean hasMoreInActivation;
        List<ActivationStoreEntry> entries = this.versionToActivations.get(from);
        ActivationStoreEntry entry = entries.get(transformationIndex);
        int unvisited = entry.getNumberOfUnvisitedActivations();
        boolean successfulVisit = unvisited > 0;
        boolean bl = hasMoreInActivation = unvisited > 1;
        if (successfulVisit) {
            transformation = transformationIndex;
            activation = entry.getAndAddActivationAfter(activationIndex);
        } else {
            transformation = -1;
            activation = -1;
        }
        if (!hasMoreInActivation) {
            boolean hasMoreInOtherTransformation = false;
            for (ActivationStoreEntry e : entries) {
                if (e == entry || e.getNumberOfUnvisitedActivations() <= 0) continue;
                hasMoreInOtherTransformation = true;
                break;
            }
            hasMore = hasMoreInOtherTransformation;
        } else {
            hasMore = true;
        }
        if (!hasMore) {
            this.actionWhenAllActivationVisited.accept(from);
        }
        return new ActivationStore.VisitResult(successfulVisit, hasMore, transformation, activation);
    }

    @Override
    public synchronized boolean hasUnmarkedActivation(VersionWithObjectiveValue version) {
        List<ActivationStoreEntry> entries = this.versionToActivations.get(version);
        boolean hasMore = false;
        for (ActivationStoreEntry entry : entries) {
            if (entry.getNumberOfUnvisitedActivations() <= 0) continue;
            hasMore = true;
            break;
        }
        return hasMore;
    }

    @Override
    public synchronized ActivationStore.VisitResult getRandomAndMarkAsVisited(VersionWithObjectiveValue version, Random random) {
        double weight;
        List<ActivationStoreEntry> entries = this.versionToActivations.get(version);
        double[] weights = new double[entries.size()];
        double totalWeight = 0.0;
        int numberOfAllUnvisitedActivations = 0;
        for (int i = 0; i < weights.length; ++i) {
            ActivationStoreEntry entry = entries.get(i);
            int unvisited = entry.getNumberOfUnvisitedActivations();
            weights[i] = weight = unvisited == 0 ? 0.0 : (double)unvisited;
            totalWeight += weight;
            numberOfAllUnvisitedActivations += unvisited;
        }
        if (numberOfAllUnvisitedActivations == 0) {
            this.actionWhenAllActivationVisited.accept(version);
            return new ActivationStore.VisitResult(false, false, -1, -1);
        }
        double offset = random.nextDouble(totalWeight);
        for (int transformation = 0; transformation < entries.size(); ++transformation) {
            weight = weights[transformation];
            if (weight > 0.0 && offset < weight) {
                ActivationStoreEntry entry = entries.get(transformation);
                int activation = random.nextInt(entry.getNumberOfActivations());
                return this.visitActivation(version, transformation, activation);
            }
            offset -= weight;
        }
        throw new AssertionError((Object)"Unvisited activation %f not found".formatted(offset));
    }
}

