/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.statespace.internal;

import org.eclipse.collections.api.factory.primitive.IntLists;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import tools.refinery.store.dse.transition.statespace.internal.ActivationStoreEntry;

public class ActivationStoreListEntry
extends ActivationStoreEntry {
    private final MutableIntList visitedActivations = IntLists.mutable.empty();

    ActivationStoreListEntry(int numberOfActivations) {
        super(numberOfActivations);
    }

    @Override
    public int getNumberOfVisitedActivations() {
        return this.visitedActivations.size();
    }

    @Override
    public int getAndAddActivationAfter(int index) {
        if (this.visitedActivations.isEmpty()) {
            this.visitedActivations.add(index);
            return index;
        }
        int positionInSearch = this.getPosition(index);
        int position = positionInSearch;
        if (position == this.visitedActivations.size()) {
            this.visitedActivations.add(index);
            return index;
        }
        if (this.visitedActivations.get(position) != index) {
            this.visitedActivations.addAtIndex(position, index);
            return index;
        }
        while (position + 1 < this.visitedActivations.size()) {
            if (this.visitedActivations.get(position + 1) - this.visitedActivations.get(position) > 1) {
                int newElement = this.visitedActivations.get(position) + 1;
                this.visitedActivations.addAtIndex(position + 1, newElement);
                return newElement;
            }
            ++position;
        }
        int last = this.visitedActivations.get(this.visitedActivations.size() - 1);
        if (last < this.numberOfActivations - 1) {
            this.visitedActivations.add(last + 1);
            return last + 1;
        }
        if (this.visitedActivations.get(0) > 0) {
            this.visitedActivations.addAtIndex(0, 0);
            return 0;
        }
        for (position = 0; position < positionInSearch; ++position) {
            if (this.visitedActivations.get(position + 1) - this.visitedActivations.get(position) <= 1) continue;
            int newElement = this.visitedActivations.get(position) + 1;
            this.visitedActivations.addAtIndex(position + 1, newElement);
            return newElement;
        }
        throw new IllegalArgumentException("There is are no unvisited activations!");
    }

    private int getPosition(int index) {
        int left = 0;
        int right = this.visitedActivations.size() - 1;
        while (left <= right) {
            int middle = (right - left) / 2 + left;
            int middleElement = this.visitedActivations.get(middle);
            if (middleElement == index) {
                return middle;
            }
            if (middleElement < index) {
                left = middle + 1;
                continue;
            }
            right = middle - 1;
        }
        return right + 1;
    }
}

