/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.statespace.internal;

import java.util.List;
import java.util.Random;
import tools.refinery.store.dse.transition.Transformation;
import tools.refinery.store.dse.transition.VersionWithObjectiveValue;
import tools.refinery.store.dse.transition.statespace.ActivationStore;
import tools.refinery.store.tuple.Tuple;

public class ActivationStoreWorker {
    final ActivationStore store;
    final List<Transformation> transformations;

    public ActivationStoreWorker(ActivationStore store, List<Transformation> transformations) {
        this.store = store;
        this.transformations = transformations;
    }

    public int[] calculateEmptyActivationSize() {
        int[] result = new int[this.transformations.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.transformations.get(i).getAllActivationsAsResultSet().size();
        }
        return result;
    }

    public ActivationStore.VisitResult fireRandomActivation(VersionWithObjectiveValue thisVersion, Random random) {
        ActivationStore.VisitResult result = this.store.getRandomAndMarkAsVisited(thisVersion, random);
        if (result.successfulVisit()) {
            Tuple tuple;
            int selectedTransformation = result.transformation();
            int selectedActivation = result.activation();
            Transformation transformation = this.transformations.get(selectedTransformation);
            boolean success = transformation.fireActivation(tuple = transformation.getActivation(selectedActivation));
            if (success) {
                return result;
            }
            return new ActivationStore.VisitResult(false, result.mayHaveMore(), selectedTransformation, selectedActivation);
        }
        return result;
    }
}

