/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.statespace.internal;

import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import tools.refinery.store.dse.transition.ObjectiveValues;
import tools.refinery.store.dse.transition.VersionWithObjectiveValue;
import tools.refinery.store.dse.transition.objectives.Objective;
import tools.refinery.store.dse.transition.statespace.ObjectivePriorityQueue;

public class ObjectivePriorityQueueImpl
implements ObjectivePriorityQueue {
    public static final Comparator<VersionWithObjectiveValue> c1 = (o1, o2) -> Double.compare(((ObjectiveValues.ObjectiveValue1)o1.objectiveValue()).value0(), ((ObjectiveValues.ObjectiveValue1)o2.objectiveValue()).value0());
    final PriorityQueue<VersionWithObjectiveValue> priorityQueue;

    public ObjectivePriorityQueueImpl(List<Objective> objectives) {
        if (objectives.size() != 1) {
            throw new UnsupportedOperationException("Only single objective comparator is implemented currently!");
        }
        this.priorityQueue = new PriorityQueue<VersionWithObjectiveValue>(c1);
    }

    @Override
    public Comparator<VersionWithObjectiveValue> getComparator() {
        return c1;
    }

    @Override
    public synchronized void submit(VersionWithObjectiveValue versionWithObjectiveValue) {
        this.priorityQueue.add(versionWithObjectiveValue);
    }

    @Override
    public synchronized void remove(VersionWithObjectiveValue versionWithObjectiveValue) {
        this.priorityQueue.remove(versionWithObjectiveValue);
    }

    @Override
    public synchronized int getSize() {
        return this.priorityQueue.size();
    }

    @Override
    public synchronized VersionWithObjectiveValue getBest() {
        return this.priorityQueue.peek();
    }

    @Override
    public synchronized VersionWithObjectiveValue getRandom(Random random) {
        int randomPosition = random.nextInt(this.getSize());
        for (VersionWithObjectiveValue entry : this.priorityQueue) {
            if (randomPosition-- != 0) continue;
            return entry;
        }
        throw new IllegalStateException("The priority queue is inconsistent!");
    }
}

