/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.statespace.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import tools.refinery.store.dse.transition.VersionWithObjectiveValue;
import tools.refinery.store.dse.transition.statespace.SolutionStore;
import tools.refinery.store.dse.transition.statespace.internal.ObjectivePriorityQueueImpl;

public class SolutionStoreImpl
implements SolutionStore {
    final int maxNumberSolutions;
    public static final int UNLIMITED = -1;
    final PriorityQueue<VersionWithObjectiveValue> solutions;

    public SolutionStoreImpl(int maxNumberSolutions) {
        this.maxNumberSolutions = maxNumberSolutions;
        this.solutions = new PriorityQueue<VersionWithObjectiveValue>(ObjectivePriorityQueueImpl.c1.reversed());
    }

    @Override
    public synchronized boolean submit(VersionWithObjectiveValue version) {
        boolean removeLast = this.hasEnoughSolution();
        this.solutions.add(version);
        if (removeLast) {
            VersionWithObjectiveValue last = this.solutions.poll();
            return last != version;
        }
        return true;
    }

    @Override
    public List<VersionWithObjectiveValue> getSolutions() {
        return new ArrayList<VersionWithObjectiveValue>(this.solutions);
    }

    @Override
    public boolean hasEnoughSolution() {
        if (this.maxNumberSolutions == -1) {
            return false;
        }
        return this.solutions.size() >= this.maxNumberSolutions;
    }
}

