package top.binfast.common.desensitise.annotation;

import top.binfast.common.desensitise.core.DesensitiseStrategy;
import top.binfast.common.desensitise.handler.DesensitiseHandler;
import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 数据脱敏注解
 *
 * @author liubin
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@JacksonAnnotationsInside
@JsonSerialize(using = DesensitiseHandler.class)
public @interface Desensitise {

    DesensitiseStrategy value();

}
