package top.binfast.common.desensitise.core;

import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.StrUtil;
import lombok.AllArgsConstructor;

import java.util.function.Function;

/**
 * 脱敏策略
 *
 * @author liubin
 */
@AllArgsConstructor
public enum DesensitiseStrategy {

//    /**
//     * 自定义
//     */
//    CUSTOMER,
    /**
     * 用户名, 刘*华, 徐*
     */
    CHINESE_NAME(s -> {
        if (StrUtil.isBlank(s)) {
            return StrUtil.EMPTY;
        }
        if (s.length() <= 2) {
            return DesensitizedUtil.chineseName(s);
        } else {
            return StrUtil.hide(s, 1, s.length()-1);
        }
    }),
    /**
     * 座机号
     */
    FIXED_PHONE(DesensitizedUtil::fixedPhone),
    /**
     * 密码, 永远是 ******, 与长度无关
     */
    PASSWORD(DesensitizedUtil::password),
//    /**
//     * 密钥, 【密钥】密钥除了最后三位其他都是***, 与长度无关
//     */
//    KEY,
    /**
     * IPV4 类型 113.123.198.176 主机部分打码 113.123.*.123
     */
    IPV4(DesensitizedUtil::ipv4),

    /**
     * 中国大陆车牌，包含普通车辆、新能源车辆
     */
    CAR_LICENSE(DesensitizedUtil::carLicense),

    /**
     * 身份证脱敏, 110***********1234
     */
    ID_CARD(s -> DesensitizedUtil.idCardNum(s, 3, 4)),

    /**
     * 手机号脱敏，176****1234
     */
    PHONE(DesensitizedUtil::mobilePhone),

    /**
     * 地址脱敏, 北京********
     */
    ADDRESS(s -> DesensitizedUtil.address(s, 8)),

    /**
     * 邮箱脱敏, d**@126.com
     */
    EMAIL(DesensitizedUtil::email),

    /**
     * 银行卡
     * eg: 1101 **** **** **** 3256
     */
    BANK_CARD(DesensitizedUtil::bankCard),

    /**
     * 用户ID
     */
    user_ID(s -> String.valueOf(DesensitizedUtil.userId())),


    /**
     * ipv6
     */
    IPV6(DesensitizedUtil::ipv6),


    /**
     * 只显示第一个字符
     */
    FIRST_MASK(DesensitizedUtil::firstMask),

    /**
     * 清空为null
     */
    CLEAR(s -> DesensitizedUtil.clear()),

    /**
     * 清空为""
     */
    CLEAR_TO_NULL(s -> DesensitizedUtil.clearToNull());

    //可自行添加其他脱敏策略

    private final Function<String, String> desensitizer;

    public Function<String, String> desensitizer() {
        return desensitizer;
    }
}
