/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.encrypt;

import cn.hutool.crypto.SecureUtil;
import jakarta.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import top.binfast.common.encrypt.config.ApiEncryptProperties;
import top.binfast.common.encrypt.core.ApiDecryptRequestBodyAdvice;
import top.binfast.common.encrypt.core.ApiEncryptResponseBodyAdvice;
import top.binfast.common.encrypt.utils.EncryptUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ApiEncryptProperties.class})
@Import(value={ApiDecryptRequestBodyAdvice.class, ApiEncryptResponseBodyAdvice.class})
@ConditionalOnProperty(value={"security.encrypt.enable"}, havingValue="true", matchIfMissing=true)
public class ApiEncryptAutoConfiguration {
    private final ApiEncryptProperties apiEncryptProperties;

    @PostConstruct
    public void init() {
        EncryptUtils.initConfig(this.apiEncryptProperties);
    }

    public ApiEncryptAutoConfiguration(ApiEncryptProperties apiEncryptProperties) {
        this.apiEncryptProperties = apiEncryptProperties;
    }

    static {
        SecureUtil.disableBouncyCastle();
    }
}

