/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.encrypt.core;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.util.StrUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;
import top.binfast.common.core.exception.PlatformException;
import top.binfast.common.encrypt.annotation.ApiDecrypt;
import top.binfast.common.encrypt.model.DecryptHttpInputMessage;
import top.binfast.common.encrypt.utils.EncryptUtils;

@Order(value=1)
@ControllerAdvice
@ConditionalOnProperty(value={"security.encrypt.enable"}, havingValue="true", matchIfMissing=true)
public class ApiDecryptRequestBodyAdvice
implements RequestBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(ApiDecryptRequestBodyAdvice.class);
    static TimedCache<String, String> cache = CacheUtil.newTimedCache((long)(DateUnit.MINUTE.getMillis() * 5L));

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return AnnotationUtil.hasAnnotation((AnnotatedElement)methodParameter.getMethod(), ApiDecrypt.class);
    }

    @Nullable
    public Object handleEmptyBody(@Nullable Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        if (parameter.getMethod() == null) {
            return inputMessage;
        }
        InputStream messageBody = inputMessage.getBody();
        if (messageBody.available() <= 0) {
            return inputMessage;
        }
        ApiDecrypt apiDecrypt = (ApiDecrypt)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)parameter.getMethod(), ApiDecrypt.class);
        if (apiDecrypt == null) {
            throw new PlatformException("\u83b7\u53d6\u89e3\u5bc6\u6ce8\u89e3\u914d\u7f6e\u4e3a\u7a7a");
        }
        HttpHeaders headers = inputMessage.getHeaders();
        String sign = EncryptUtils.getFromHead(headers, "sign");
        byte[] bodyByteArray = StreamUtils.copyToByteArray((InputStream)messageBody);
        String sha256Sign = EncryptUtils.getSHA256Str(StrUtil.str((byte[])bodyByteArray, (Charset)StandardCharsets.UTF_8));
        if (!sha256Sign.equals(sign)) {
            throw new PlatformException("\u6570\u636e\u7b7e\u540d\u9519\u8bef\uff01");
        }
        String appId = EncryptUtils.getFromHead(headers, "appId", false);
        String nonce = EncryptUtils.getFromHead(headers, "nonce");
        String timestamp = EncryptUtils.getFromHead(headers, "timestamp");
        String appSign = EncryptUtils.getFromHead(headers, "appSign");
        long now = System.currentTimeMillis();
        if (timestamp == null || (now - Long.parseLong(timestamp)) / 1000L / 60L >= 5L) {
            throw new PlatformException("\u8bf7\u6c42\u8fc7\u671f\uff01");
        }
        String str = (String)cache.get((Object)(appId + "_" + nonce), false);
        if (Objects.nonNull(str)) {
            throw new PlatformException("\u8bf7\u6c42\u5931\u6548\uff01");
        }
        cache.put((Object)(appId + "_" + nonce), (Object)"1");
        HashMap<String, String> signMap = new HashMap<String, String>();
        signMap.put("appId", appId);
        signMap.put("nonce", nonce);
        signMap.put("timestamp", timestamp);
        signMap.put("sign", sign);
        String signStr = EncryptUtils.buildSignStr(signMap, EncryptUtils.getAppSecret(appId));
        try {
            if (!EncryptUtils.rsaVerifySignature(signStr, EncryptUtils.getAppPublicKey(appId), appSign)) {
                throw new PlatformException("\u516c\u94a5\u9a8c\u7b7e\u9519\u8bef\uff01");
            }
        }
        catch (Exception e) {
            throw new PlatformException("\u516c\u94a5\u9a8c\u7b7e\u51fa\u73b0\u95ee\u9898\u9519\u8bef\uff01" + e.getMessage());
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bodyByteArray);
        return new DecryptHttpInputMessage(inputStream, headers);
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    static {
        cache.schedulePrune(DateUnit.MINUTE.getMillis() * 10L);
    }
}

