/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.encrypt.core;

import cn.hutool.core.annotation.AnnotationUtil;
import com.alibaba.cola.dto.MultiResponse;
import com.alibaba.cola.dto.PageResponse;
import com.alibaba.cola.dto.Response;
import com.alibaba.cola.dto.SingleResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.AnnotatedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import top.binfast.common.core.exception.PlatformException;
import top.binfast.common.encrypt.annotation.ApiEncrypt;
import top.binfast.common.encrypt.utils.EncryptUtils;

@Order(value=1)
@ControllerAdvice
@ConditionalOnProperty(value={"security.encrypt.enable"}, havingValue="true", matchIfMissing=true)
public class ApiEncryptResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ApiEncryptResponseBodyAdvice.class);
    private final ObjectMapper objectMapper;

    public boolean supports(MethodParameter returnType, Class converterType) {
        return AnnotationUtil.hasAnnotation((AnnotatedElement)returnType.getMethod(), ApiEncrypt.class);
    }

    @Nullable
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        String encryptData;
        if (body == null) {
            return null;
        }
        if (returnType.getMethod() == null) {
            return body;
        }
        ApiEncrypt apiEncrypt = (ApiEncrypt)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)returnType.getMethod(), ApiEncrypt.class);
        if (apiEncrypt == null) {
            throw new PlatformException("\u83b7\u53d6\u52a0\u5bc6\u6ce8\u89e3\u914d\u7f6e\u4e3a\u7a7a");
        }
        String appId = EncryptUtils.getFromHead(request.getHeaders(), "appId");
        if (!(body instanceof Response)) {
            return body;
        }
        Response bodyResponse = (Response)body;
        if (!bodyResponse.isSuccess()) {
            return body;
        }
        Object data = null;
        if (bodyResponse instanceof SingleResponse) {
            data = ((SingleResponse)bodyResponse).getData();
        } else if (body instanceof PageResponse) {
            data = ((PageResponse)bodyResponse).getData();
        } else if (body instanceof MultiResponse) {
            data = ((MultiResponse)bodyResponse).getData();
        }
        try {
            encryptData = EncryptUtils.encryptByAes(this.objectMapper.writeValueAsString(data), EncryptUtils.getAppEncryptKey(appId));
        }
        catch (JsonProcessingException e) {
            throw new PlatformException("\u52a0\u5bc6\u65f6json\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        SingleResponse singleResponse = new SingleResponse();
        singleResponse.setSuccess(bodyResponse.isSuccess());
        singleResponse.setErrCode(bodyResponse.getErrCode());
        singleResponse.setErrMessage(bodyResponse.getErrMessage());
        singleResponse.setData((Object)encryptData);
        return singleResponse;
    }

    public ApiEncryptResponseBodyAdvice(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

