/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.encrypt.utils;

import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import top.binfast.common.core.exception.PlatformException;
import top.binfast.common.encrypt.config.ApiEncryptProperties;
import top.binfast.common.encrypt.model.RsaKeyConfig;

public class EncryptUtils {
    private static final Logger log = LoggerFactory.getLogger(EncryptUtils.class);
    static Map<String, String> appMap;
    static Map<String, RsaKeyConfig> appKeyPair;

    public static void initConfig(ApiEncryptProperties apiEncryptProperties) {
        appMap = new HashMap<String, String>(16);
        appKeyPair = new HashMap<String, RsaKeyConfig>(16);
        appMap.put(apiEncryptProperties.getAppId(), apiEncryptProperties.getAppSecret());
        RsaKeyConfig rsaKeyConfig = new RsaKeyConfig();
        rsaKeyConfig.setPrivateKey(apiEncryptProperties.getRsaPrivateKey());
        rsaKeyConfig.setPublicKey(apiEncryptProperties.getRsaPublicKey());
        rsaKeyConfig.setEncryptKey(apiEncryptProperties.getAesKey());
        appKeyPair.put(apiEncryptProperties.getAppId(), rsaKeyConfig);
    }

    public static String getAppSecret(String appId) {
        if (appMap.containsKey(appId)) {
            return appMap.get(appId);
        }
        log.error("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u3010{}\u3011\u7684\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\uff01", (Object)appId);
        return null;
    }

    public static String getAppPublicKey(String appId) {
        if (appKeyPair.containsKey(appId)) {
            return appKeyPair.get(appId).getPublicKey();
        }
        log.error("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u3010{}\u3011\u7684RSA\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\uff01", (Object)appId);
        return null;
    }

    public static String getAppPrivateKey(String appId) {
        if (appKeyPair.containsKey(appId)) {
            return appKeyPair.get(appId).getPrivateKey();
        }
        log.error("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u3010{}\u3011\u7684RSA\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\uff01", (Object)appId);
        return null;
    }

    public static String getAppEncryptKey(String appId) {
        if (appKeyPair.containsKey(appId)) {
            return appKeyPair.get(appId).getEncryptKey();
        }
        log.error("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u3010{}\u3011\u7684AES\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\uff01", (Object)appId);
        return null;
    }

    public static String sha256withRSASignature(String privateKeyStr, String dataStr) {
        try {
            byte[] key = Base64.getDecoder().decode(privateKeyStr);
            byte[] data = dataStr.getBytes();
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(data);
            return new String(Base64.getEncoder().encode(signature.sign()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    public static boolean rsaVerifySignature(String dataStr, String publicKeyStr, String signStr) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyStr));
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initVerify(publicKey);
        signature.update(dataStr.getBytes());
        return signature.verify(Base64.getDecoder().decode(signStr));
    }

    public static String buildSignStr(Map<String, String> params, String appSecret) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        Set<String> keySet = params.keySet();
        Object[] keyArray = keySet.toArray(new String[0]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object key : keyArray) {
            String value = params.get(key);
            if (StrUtil.isBlank((CharSequence)value)) continue;
            sb.append((String)key).append("=").append(value).append("&");
        }
        sb.append("appSecret=").append(appSecret);
        return sb.toString();
    }

    public static void initKeyPair(String appId) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RsaKeyConfig rsaKeyConfig = new RsaKeyConfig();
        rsaKeyConfig.setPublicKey(new String(Base64.getEncoder().encode(publicKey.getEncoded())));
        rsaKeyConfig.setPrivateKey(new String(Base64.getEncoder().encode(privateKey.getEncoded())));
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey secretKey = keyGen.generateKey();
        rsaKeyConfig.setEncryptKey(new String(Base64.getEncoder().encode(secretKey.getEncoded())));
        appKeyPair.put(appId, rsaKeyConfig);
    }

    public static String encryptByAes(String data, String key) {
        if (StrUtil.isBlank((CharSequence)key)) {
            throw new RuntimeException("AES\u52a0\u5bc6\u5931\u8d25\uff0ckey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            return SecureUtil.aes((byte[])key.getBytes(StandardCharsets.UTF_8)).encryptHex(data, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("AES\u52a0\u5bc6\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    public static String decryptByAes(String data, String key) {
        if (StrUtil.isBlank((CharSequence)key)) {
            throw new RuntimeException("AES\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        return SecureUtil.aes((byte[])key.getBytes(StandardCharsets.UTF_8)).decryptStr(data, StandardCharsets.UTF_8);
    }

    public static String getSHA256Str(String str) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] hash = messageDigest.digest(str.getBytes(StandardCharsets.UTF_8));
        return HexUtil.encodeHexStr((byte[])hash);
    }

    public static String getFromHead(HttpHeaders headers, String headName) {
        return EncryptUtils.getFromHead(headers, headName, true);
    }

    public static String getFromHead(HttpHeaders headers, String headName, Boolean remove) {
        List list;
        try {
            list = remove.booleanValue() ? headers.remove((Object)headName) : headers.getOrEmpty((Object)headName);
        }
        catch (NullPointerException e) {
            throw new PlatformException("\u9a8c\u7b7e\u65f6\uff0c" + headName + "\u4e0d\u5b58\u5728\uff01");
        }
        if (list.size() == 0) {
            throw new PlatformException("\u9a8c\u7b7e\u65f6\uff0c" + headName + "\u4e0d\u5b58\u5728\uff01");
        }
        String head = (String)list.get(0);
        if (StrUtil.isBlank((CharSequence)head)) {
            throw new PlatformException("\u9a8c\u7b7e\u65f6\uff0c" + headName + "\u4e3a\u7a7a\uff01");
        }
        return head;
    }
}

