/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.mybatis.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import top.binfast.common.core.util.SnGen;
import top.binfast.common.mybatis.config.MybatisPlusMetaObjectHandler;
import top.binfast.common.mybatis.datascope.core.BinDataPermissionHandler;
import top.binfast.common.mybatis.datascope.core.DataScope;
import top.binfast.common.mybatis.datascope.core.DeptDataScope;
import top.binfast.common.mybatis.datascope.interceptor.DataPermissionInterceptor;
import top.binfast.common.mybatis.mapper.injected.BinSqlInjector;
import top.binfast.common.mybatis.tenant.core.TenantHelper;
import top.binfast.common.mybatis.tenant.handler.BinTenantHandler;
import top.binfast.common.mybatis.tenant.properties.TenantProperties;

@ConditionalOnBean(value={DataSource.class})
@EnableConfigurationProperties(value={TenantProperties.class})
@AutoConfiguration(before={MybatisPlusAutoConfiguration.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class MybatisPlusConfiguration {
    @Bean
    public MybatisPlusMetaObjectHandler mybatisPlusMetaObjectHandler() {
        return new MybatisPlusMetaObjectHandler();
    }

    @Bean
    public BinSqlInjector dataScopeSqlInjector() {
        return new BinSqlInjector();
    }

    @Bean
    public DataScope deptDataScope() {
        return new DeptDataScope();
    }

    @Bean
    @ConditionalOnBean(value={DataScope.class})
    public MybatisPlusInterceptor mybatisPlusInterceptor(List<DataScope> dataScopeList, TenantProperties tenantProperties) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        if (TenantHelper.isEnable()) {
            TenantLineInnerInterceptor tenantLineInnerInterceptor = new TenantLineInnerInterceptor();
            tenantLineInnerInterceptor.setTenantLineHandler((TenantLineHandler)new BinTenantHandler(tenantProperties));
            interceptor.addInnerInterceptor((InnerInterceptor)tenantLineInnerInterceptor);
        }
        DataPermissionInterceptor dataPermissionInterceptor = new DataPermissionInterceptor(new BinDataPermissionHandler(dataScopeList));
        interceptor.addInnerInterceptor((InnerInterceptor)dataPermissionInterceptor);
        PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor();
        paginationInnerInterceptor.setMaxLimit(Long.valueOf(1000L));
        paginationInnerInterceptor.setDbType(DbType.MYSQL);
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInnerInterceptor);
        return interceptor;
    }

    @Bean
    public IdentifierGenerator idGenerator() {
        return new CustomIdGenerator(new SnGen());
    }

    public class CustomIdGenerator
    implements IdentifierGenerator {
        private final SnGen snGen;

        public CustomIdGenerator(SnGen snGen) {
            this.snGen = snGen;
        }

        public Long nextId(Object entity) {
            return this.snGen.nextId();
        }
    }
}

