/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.mybatis.config;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import top.binfast.common.satoken.model.LoginUser;
import top.binfast.common.satoken.util.SecurityUtils;

public class MybatisPlusMetaObjectHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusMetaObjectHandler.class);

    public void insertFill(MetaObject metaObject) {
        log.debug("mybatis plus start insert fill ....");
        Date now = new Date();
        MybatisPlusMetaObjectHandler.fillValIfNullByName("createAt", now, metaObject, false);
        MybatisPlusMetaObjectHandler.fillValIfNullByName("modifyAt", now, metaObject, false);
        MybatisPlusMetaObjectHandler.fillValIfNullByName("creatorId", this.getUserId(), metaObject, false);
        MybatisPlusMetaObjectHandler.fillValIfNullByName("modifierId", this.getUserId(), metaObject, false);
        MybatisPlusMetaObjectHandler.fillValIfNullByName("deleted", 0, metaObject, false);
    }

    public void updateFill(MetaObject metaObject) {
        log.debug("mybatis plus start update fill ....");
        MybatisPlusMetaObjectHandler.fillValIfNullByName("modifyAt", LocalDateTime.now(), metaObject, true);
        MybatisPlusMetaObjectHandler.fillValIfNullByName("modifierId", this.getUserId(), metaObject, true);
    }

    private static void fillValIfNullByName(String fieldName, Object fieldVal, MetaObject metaObject, boolean isCover) {
        if (fieldVal == null) {
            return;
        }
        if (!metaObject.hasSetter(fieldName)) {
            return;
        }
        Object userSetValue = metaObject.getValue(fieldName);
        String setValueStr = StrUtil.str((Object)userSetValue, (Charset)Charset.defaultCharset());
        if (StrUtil.isNotBlank((CharSequence)setValueStr) && !isCover) {
            return;
        }
        Class getterType = metaObject.getGetterType(fieldName);
        if (ClassUtils.isAssignableValue((Class)getterType, (Object)fieldVal)) {
            metaObject.setValue(fieldName, fieldVal);
        }
    }

    private Long getUserId() {
        try {
            LoginUser binSysUser = (LoginUser)SecurityUtils.getCurrentUser();
            if (binSysUser != null) {
                return binSysUser.getId();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }
}

