/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.mybatis.datascope.core;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.handler.MultiDataPermissionHandler;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.binfast.common.core.exception.PlatformException;
import top.binfast.common.mybatis.datascope.annotation.DataPermission;
import top.binfast.common.mybatis.datascope.core.DataScope;
import top.binfast.common.satoken.model.LoginUser;
import top.binfast.common.satoken.util.SecurityUtils;

public class BinDataPermissionHandler
implements MultiDataPermissionHandler {
    private static final Logger log = LoggerFactory.getLogger(BinDataPermissionHandler.class);
    private final List<DataScope> dataScopes;
    private final Map<String, DataPermission> dataPermissionCacheMap = new ConcurrentHashMap<String, DataPermission>();

    public Expression getSqlSegment(Table table, Expression where, String mappedStatementId) {
        LoginUser binSysUser;
        DataPermission dataPermission = this.findAnnotation(mappedStatementId);
        String sqlSegment = this.buildSqlSegment(dataPermission, binSysUser = (LoginUser)SecurityUtils.getCurrentUser());
        if (StringUtils.isBlank((CharSequence)sqlSegment)) {
            return null;
        }
        try {
            Expression expression = CCJSqlParserUtil.parseExpression((String)sqlSegment);
            log.info("{} {} AS {} : {}", new Object[]{mappedStatementId, table.getName(), table.getAlias(), expression.toString()});
            return expression;
        }
        catch (JSQLParserException e) {
            throw new PlatformException("\u6570\u636e\u6743\u9650\u89e3\u6790\u5f02\u5e38 => " + e.getMessage());
        }
    }

    public String buildSqlSegment(DataPermission dataPermission, LoginUser binSysUser) {
        List filterDataScopes = this.dataScopes.stream().filter(dataScope -> dataScope.support(dataPermission.type())).collect(Collectors.toList());
        if (filterDataScopes.isEmpty()) {
            return null;
        }
        DataScope dataScope2 = (DataScope)filterDataScopes.get(0);
        return dataScope2.buildExpression(dataPermission.value(), binSysUser);
    }

    public DataPermission findAnnotation(String mappedStatementId) {
        Class clazz;
        DataPermission dataPermission = this.dataPermissionCacheMap.get(mappedStatementId);
        if (ObjectUtil.isNotNull((Object)dataPermission)) {
            return dataPermission;
        }
        StringBuilder sb = new StringBuilder(mappedStatementId);
        int index = sb.lastIndexOf(".");
        String clazzName = sb.substring(0, index);
        String methodName = sb.substring(index + 1, sb.length());
        dataPermission = this.dataPermissionCacheMap.get(clazzName);
        if (ObjectUtil.isNotNull((Object)dataPermission)) {
            return dataPermission;
        }
        try {
            clazz = ClassUtil.loadClass((String)clazzName);
        }
        catch (Exception e) {
            return null;
        }
        List<Method> methods = Arrays.stream(ClassUtil.getDeclaredMethods((Class)clazz)).filter(method -> method.getName().equals(methodName)).toList();
        for (Method method2 : methods) {
            if (!AnnotationUtil.hasAnnotation((AnnotatedElement)method2, DataPermission.class)) continue;
            dataPermission = (DataPermission)AnnotationUtil.getAnnotation((AnnotatedElement)method2, DataPermission.class);
            this.dataPermissionCacheMap.put(mappedStatementId, dataPermission);
            return dataPermission;
        }
        if (AnnotationUtil.hasAnnotation((AnnotatedElement)clazz, DataPermission.class)) {
            dataPermission = (DataPermission)AnnotationUtil.getAnnotation((AnnotatedElement)clazz, DataPermission.class);
            this.dataPermissionCacheMap.put(clazz.getName(), dataPermission);
            return dataPermission;
        }
        return null;
    }

    public BinDataPermissionHandler(List<DataScope> dataScopes) {
        this.dataScopes = dataScopes;
    }
}

