/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.mybatis.datascope.core;

import cn.hutool.core.util.StrUtil;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import top.binfast.common.core.bean.dto.SysRoleVO;
import top.binfast.common.core.exception.PlatformException;
import top.binfast.common.mybatis.datascope.annotation.DataColumn;
import top.binfast.common.mybatis.datascope.constants.DataAccessType;
import top.binfast.common.mybatis.datascope.core.DataScope;
import top.binfast.common.satoken.model.LoginUser;

public class DeptDataScope
implements DataScope {
    public static final String DATA_SCOPE_TYPE = "deptDataScope";
    public static final String DEPT_DATA_SCOPE_KEY = "deptColumn";
    public static final String USER_DATA_SCOPE_KEY = "userColumn";

    @Override
    public String buildExpression(DataColumn[] dataColumns, LoginUser loginUser) {
        StringBuilder builder = new StringBuilder();
        DataColumn deptColumn = null;
        DataColumn userColumn = null;
        for (DataColumn dataColumn : dataColumns) {
            if (Objects.equals(dataColumn.key(), DEPT_DATA_SCOPE_KEY)) {
                deptColumn = dataColumn;
                continue;
            }
            if (!Objects.equals(dataColumn.key(), USER_DATA_SCOPE_KEY)) continue;
            userColumn = dataColumn;
        }
        if (deptColumn == null || userColumn == null) {
            throw new PlatformException("\u672a\u63d0\u4f9b\u90e8\u95e8\u6216\u7528\u6237\u7684\u5217\u5b57\u6bb5\u6743\u9650");
        }
        SysRoleVO sysRoleVO = loginUser.getRoleVOS().stream().min(Comparator.comparingInt(SysRoleVO::getDataScope)).orElse(null);
        Integer dataScopeType = Optional.ofNullable(sysRoleVO).map(SysRoleVO::getDataScope).orElse(0);
        if (dataScopeType == 0) {
            builder.append(" 1 = 0 ");
        } else if (Objects.equals(DataAccessType.ALL.getType(), dataScopeType)) {
            builder.append(" 1 = 1 ");
        } else if (Objects.equals(DataAccessType.ORG_AND_CHILD.getType(), dataScopeType)) {
            builder.append(StrUtil.format((CharSequence)" {} IN ( SELECT id FROM admin_dept WHERE id = {} or node_path like '%/{}/%' ) ", (Object[])new Object[]{deptColumn.value(), loginUser.getDeptId(), loginUser.getDeptId()}));
        } else if (Objects.equals(DataAccessType.ORG.getType(), dataScopeType)) {
            builder.append(StrUtil.format((CharSequence)" {} = {} ", (Object[])new Object[]{deptColumn.value(), loginUser.getDeptId()}));
        } else if (Objects.equals(DataAccessType.SELF.getType(), dataScopeType)) {
            builder.append(StrUtil.format((CharSequence)" {} = {} ", (Object[])new Object[]{userColumn.value(), loginUser.getId()}));
        } else if (Objects.equals(DataAccessType.CUSTOM.getType(), dataScopeType)) {
            builder.append(StrUtil.format((CharSequence)" {} IN ( SELECT dept_id FROM admin_role_dept WHERE role_id = {} ) ", (Object[])new Object[]{deptColumn.value(), sysRoleVO.getId()}));
        } else {
            builder.append(" 1 = 0 ");
        }
        builder.insert(0, " (").append(")");
        return builder.toString();
    }

    @Override
    public boolean support(String type) {
        return DATA_SCOPE_TYPE.equals(type);
    }
}

