/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.mybatis.datascope.interceptor;

import cn.hutool.core.collection.ConcurrentHashSet;
import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.inner.BaseMultiTableInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import top.binfast.common.mybatis.datascope.annotation.DataPermission;
import top.binfast.common.mybatis.datascope.core.BinDataPermissionHandler;

public class DataPermissionInterceptor
extends BaseMultiTableInnerInterceptor
implements InnerInterceptor {
    private final BinDataPermissionHandler dataPermissionHandler;
    private final Set<String> invalidCacheSet = new ConcurrentHashSet();

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (this.checkIgnore(ms.getId())) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), ms.getId()));
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            if (this.checkIgnore(ms.getId())) {
                return;
            }
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.parserMulti(mpBs.sql(), ms.getId()));
        }
    }

    private boolean checkIgnore(String mappedStatementId) {
        if (InterceptorIgnoreHelper.willIgnoreDataPermission((String)mappedStatementId)) {
            return true;
        }
        if (this.invalidCacheSet.contains(mappedStatementId)) {
            return true;
        }
        DataPermission dataPermission = this.dataPermissionHandler.findAnnotation(mappedStatementId);
        if (dataPermission == null || ArrayUtil.isEmpty((Object[])dataPermission.value())) {
            this.invalidCacheSet.add(mappedStatementId);
            return true;
        }
        return false;
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
        String whereSegment = (String)obj;
        this.processSelectBody(select, whereSegment);
        List withItemsList = select.getWithItemsList();
        if (!CollectionUtils.isEmpty((Collection)withItemsList)) {
            withItemsList.forEach(withItem -> this.processSelectBody((Select)withItem, whereSegment));
        }
    }

    protected void processUpdate(Update update, int index, String sql, Object obj) {
        Expression sqlSegment = this.andExpression(update.getTable(), update.getWhere(), (String)obj);
        if (null != sqlSegment) {
            update.setWhere(sqlSegment);
        }
    }

    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        Expression sqlSegment = this.andExpression(delete.getTable(), delete.getWhere(), (String)obj);
        if (null != sqlSegment) {
            delete.setWhere(sqlSegment);
        }
    }

    public Expression buildTableExpression(Table table, Expression where, String whereSegment) {
        return this.dataPermissionHandler.getSqlSegment(table, where, whereSegment);
    }

    public DataPermissionInterceptor(BinDataPermissionHandler dataPermissionHandler) {
        this.dataPermissionHandler = dataPermissionHandler;
    }

    public String toString() {
        return "DataPermissionInterceptor(super=" + super.toString() + ", dataPermissionHandler=" + this.dataPermissionHandler + ", invalidCacheSet=" + this.invalidCacheSet + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPermissionInterceptor)) {
            return false;
        }
        DataPermissionInterceptor other = (DataPermissionInterceptor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinDataPermissionHandler this$dataPermissionHandler = this.dataPermissionHandler;
        BinDataPermissionHandler other$dataPermissionHandler = other.dataPermissionHandler;
        if (this$dataPermissionHandler == null ? other$dataPermissionHandler != null : !this$dataPermissionHandler.equals(other$dataPermissionHandler)) {
            return false;
        }
        Set<String> this$invalidCacheSet = this.invalidCacheSet;
        Set<String> other$invalidCacheSet = other.invalidCacheSet;
        return !(this$invalidCacheSet == null ? other$invalidCacheSet != null : !((Object)this$invalidCacheSet).equals(other$invalidCacheSet));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataPermissionInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BinDataPermissionHandler $dataPermissionHandler = this.dataPermissionHandler;
        result = result * 59 + ($dataPermissionHandler == null ? 43 : $dataPermissionHandler.hashCode());
        Set<String> $invalidCacheSet = this.invalidCacheSet;
        result = result * 59 + ($invalidCacheSet == null ? 43 : ((Object)$invalidCacheSet).hashCode());
        return result;
    }
}

