/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.mybatis.tenant;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.hutool.extra.spring.SpringUtil;
import org.redisson.api.NameMapper;
import org.redisson.spring.starter.RedissonAutoConfigurationCustomizer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import top.binfast.common.mybatis.config.MybatisPlusConfiguration;
import top.binfast.common.mybatis.tenant.core.TenantKeyPrefixHandler;
import top.binfast.common.mybatis.tenant.core.TenantSaTokenDao;
import top.binfast.common.redis.config.RedisConfig;

@AutoConfiguration(after={RedisConfig.class, MybatisPlusConfiguration.class})
@ConditionalOnProperty(value={"tenant.enable"}, havingValue="true")
public class TenantAutoConfiguration {
    @Bean
    public RedissonAutoConfigurationCustomizer tenantRedissonCustomizer() {
        return config -> {
            TenantKeyPrefixHandler nameMapper = new TenantKeyPrefixHandler(SpringUtil.getProperty((String)"redis.redisson.keyPrefix"));
            if (config.isClusterConfig()) {
                config.useClusterServers().setNameMapper((NameMapper)nameMapper);
            } else if (config.isSentinelConfig()) {
                config.useSentinelServers().setNameMapper((NameMapper)nameMapper);
            } else {
                config.useSingleServer().setNameMapper((NameMapper)nameMapper);
            }
        };
    }

    @Primary
    @Bean
    public SaTokenDao tenantSaTokenDao() {
        return new TenantSaTokenDao();
    }
}

