/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.mybatis.tenant.core;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.core.plugins.IgnoreStrategy;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.binfast.common.redis.util.RedisUtil;
import top.binfast.common.satoken.util.SecurityUtils;

public class TenantHelper {
    private static final Logger log = LoggerFactory.getLogger(TenantHelper.class);
    private static final ThreadLocal<Long> THREAD_LOCAL_TENANT = new ThreadLocal();

    public static void enableIgnore() {
        InterceptorIgnoreHelper.handle((IgnoreStrategy)IgnoreStrategy.builder().tenantLine(Boolean.valueOf(true)).build());
    }

    public static void disableIgnore() {
        InterceptorIgnoreHelper.clearIgnoreStrategy();
    }

    public static void ignore(Runnable handle) {
        TenantHelper.enableIgnore();
        try {
            handle.run();
        }
        finally {
            TenantHelper.disableIgnore();
        }
    }

    public static <T> T ignore(Supplier<T> handle) {
        TenantHelper.enableIgnore();
        try {
            T t = handle.get();
            return t;
        }
        finally {
            TenantHelper.disableIgnore();
        }
    }

    public static boolean isEnable() {
        return Convert.toBool((Object)SpringUtil.getProperty((String)"tenant.enable"), (Boolean)false);
    }

    public static void setDynamic(Long tenantId) {
        TenantHelper.setDynamic(tenantId, false);
    }

    public static void setDynamic(Long tenantId, boolean global) {
        if (!TenantHelper.isEnable()) {
            return;
        }
        if (!TenantHelper.isLogin() || !global) {
            THREAD_LOCAL_TENANT.set(tenantId);
            return;
        }
        String cacheKey = "global:dynamicTenant:" + SecurityUtils.getCurrentUserId();
        RedisUtil.setCacheObject((String)cacheKey, (Object)tenantId);
    }

    public static Long getDynamic() {
        if (!TenantHelper.isEnable()) {
            return null;
        }
        if (!TenantHelper.isLogin()) {
            return THREAD_LOCAL_TENANT.get();
        }
        Long tenantId = THREAD_LOCAL_TENANT.get();
        if (tenantId != null) {
            return tenantId;
        }
        String cacheKey = "global:dynamicTenant:" + SecurityUtils.getCurrentUserId();
        tenantId = (Long)RedisUtil.getCacheObject((String)cacheKey);
        return tenantId;
    }

    public static void clearDynamic() {
        if (!TenantHelper.isEnable()) {
            return;
        }
        if (!TenantHelper.isLogin()) {
            THREAD_LOCAL_TENANT.remove();
            return;
        }
        THREAD_LOCAL_TENANT.remove();
        String cacheKey = "global:dynamicTenant:" + SecurityUtils.getCurrentUserId();
        RedisUtil.deleteObject((String)cacheKey);
    }

    public static void dynamic(Long tenantId, Runnable handle) {
        Long pre = TenantHelper.getDynamic();
        try {
            TenantHelper.setDynamic(tenantId);
            log.trace("TenantBroker \u5207\u6362\u79df\u6237{} -> {}", (Object)pre, (Object)tenantId);
            handle.run();
        }
        finally {
            log.trace("TenantBroker \u8fd8\u539f\u79df\u6237{} <- {}", (Object)pre, (Object)tenantId);
            TenantHelper.clearDynamic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T dynamic(Long tenantId, Supplier<T> handle) {
        Long pre = TenantHelper.getDynamic();
        try {
            TenantHelper.setDynamic(tenantId);
            log.trace("TenantBroker \u5207\u6362\u79df\u6237{} -> {}", (Object)pre, (Object)tenantId);
            T t = handle.get();
            return t;
        }
        finally {
            log.trace("TenantBroker \u8fd8\u539f\u79df\u6237{} <- {}", (Object)pre, (Object)tenantId);
            TenantHelper.clearDynamic();
        }
    }

    public static Long getTenantId() {
        if (!TenantHelper.isEnable()) {
            return null;
        }
        Long tenantId = TenantHelper.getDynamic();
        if (tenantId == null) {
            tenantId = SecurityUtils.getTenantId();
        }
        return tenantId;
    }

    private static boolean isLogin() {
        try {
            StpUtil.checkLogin();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

