/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.mybatis.tenant.core;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.binfast.common.mybatis.tenant.core.TenantHelper;
import top.binfast.common.redis.handler.KeyPrefixHandler;

public class TenantKeyPrefixHandler
extends KeyPrefixHandler {
    private static final Logger log = LoggerFactory.getLogger(TenantKeyPrefixHandler.class);

    public TenantKeyPrefixHandler(String keyPrefix) {
        super(keyPrefix);
    }

    public String map(String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return null;
        }
        if (InterceptorIgnoreHelper.willIgnoreTenantLine((String)"")) {
            return super.map(name);
        }
        if (StrUtil.contains((CharSequence)name, (CharSequence)"global:")) {
            return super.map(name);
        }
        Long tenantId = TenantHelper.getTenantId();
        if (tenantId == null) {
            log.error("\u65e0\u6cd5\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237id -> Null");
            return super.map(name);
        }
        if (StrUtil.startWith((CharSequence)name, (CharSequence)("" + tenantId))) {
            return super.map(name);
        }
        return super.map(tenantId + ":" + name);
    }

    public String unmap(String name) {
        String unmap = super.unmap(name);
        if (StrUtil.isBlank((CharSequence)unmap)) {
            return null;
        }
        if (InterceptorIgnoreHelper.willIgnoreTenantLine((String)"")) {
            return super.unmap(name);
        }
        if (StrUtil.contains((CharSequence)name, (CharSequence)"global:")) {
            return super.unmap(name);
        }
        Long tenantId = TenantHelper.getTenantId();
        if (tenantId == null) {
            log.error("\u65e0\u6cd5\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237id -> Null");
            return super.unmap(name);
        }
        if (StrUtil.startWith((CharSequence)unmap, (CharSequence)("" + tenantId))) {
            return unmap.substring((tenantId + ":").length());
        }
        return unmap;
    }
}

