/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.mybatis.tenant.core;

import java.time.Duration;
import java.util.List;
import top.binfast.common.redis.util.RedisUtil;
import top.binfast.common.satoken.dao.BinSaTokenDao;

public class TenantSaTokenDao
extends BinSaTokenDao {
    public String get(String key) {
        return super.get("global:" + key);
    }

    public void set(String key, String value, long timeout) {
        super.set("global:" + key, value, timeout);
    }

    public void update(String key, String value) {
        long expire = this.getTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.set(key, value, expire);
    }

    public void delete(String key) {
        super.delete("global:" + key);
    }

    public long getTimeout(String key) {
        return super.getTimeout("global:" + key);
    }

    public void updateTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getTimeout(key);
            if (expire != -1L) {
                this.set(key, this.get(key), timeout);
            }
            return;
        }
        RedisUtil.expire((String)("global:" + key), (Duration)Duration.ofSeconds(timeout));
    }

    public Object getObject(String key) {
        return super.getObject("global:" + key);
    }

    public void setObject(String key, Object object, long timeout) {
        super.setObject("global:" + key, object, timeout);
    }

    public void updateObject(String key, Object object) {
        long expire = this.getObjectTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.setObject(key, object, expire);
    }

    public void deleteObject(String key) {
        super.deleteObject("global:" + key);
    }

    public long getObjectTimeout(String key) {
        return super.getObjectTimeout("global:" + key);
    }

    public void updateObjectTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getObjectTimeout(key);
            if (expire != -1L) {
                this.setObject(key, this.getObject(key), timeout);
            }
            return;
        }
        RedisUtil.expire((String)("global:" + key), (Duration)Duration.ofSeconds(timeout));
    }

    public List<String> searchData(String prefix, String keyword, int start, int size, boolean sortType) {
        return super.searchData("global:" + prefix, keyword, start, size, sortType);
    }
}

