/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.mybatis.tenant.handler;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.binfast.common.mybatis.tenant.core.TenantHelper;
import top.binfast.common.mybatis.tenant.properties.TenantProperties;

public class BinTenantHandler
implements TenantLineHandler {
    private static final Logger log = LoggerFactory.getLogger(BinTenantHandler.class);
    private final TenantProperties tenantProperties;

    public Expression getTenantId() {
        Long tenantId = TenantHelper.getTenantId();
        if (tenantId == null) {
            log.debug("\u5f53\u524d\u79df\u6237\u4e0d\u5b58\u5728");
            return new NullValue();
        }
        return new LongValue(tenantId.longValue());
    }

    public String getTenantIdColumn() {
        return this.tenantProperties.getColumn();
    }

    public boolean ignoreTable(String tableName) {
        Long tenantId = TenantHelper.getTenantId();
        if (tenantId == null) {
            return true;
        }
        List<String> excludes = this.tenantProperties.getExcludes();
        return excludes.contains(tableName);
    }

    public BinTenantHandler(TenantProperties tenantProperties) {
        this.tenantProperties = tenantProperties;
    }
}

