/*
 * Decompiled with CFR 0.152.
 */
package top.binfast.common.mybatis.util;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cola.dto.PageResponse;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.ColumnCache;
import com.baomidou.mybatisplus.core.toolkit.support.LambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import top.binfast.common.core.bean.params.BasePageSortParam;
import top.binfast.common.core.bean.params.SortParam;

public class QueryUtil {
    public static <T> Page<T> getPage(BasePageSortParam pageSortParam, SortParam ... sortParams) {
        Page page = new Page((long)pageSortParam.getPageNo().intValue(), (long)pageSortParam.getPageSize().intValue());
        page.addOrder(QueryUtil.initOrderBy(pageSortParam.buildSort(), sortParams));
        return page;
    }

    public static <T, X> PageResponse<X> getPageResponse(List<X> result, Page<T> page) {
        return PageResponse.of(result, (int)((int)page.getTotal()), (int)((int)page.getSize()), (int)((int)page.getCurrent()));
    }

    public static <T> PageResponse<T> getPageResponse(Page<T> page) {
        return PageResponse.of((Collection)page.getRecords(), (int)((int)page.getTotal()), (int)((int)page.getSize()), (int)((int)page.getCurrent()));
    }

    public static <T, U> PageResponse<T> getPageResponse(Page<U> page, Function<List<U>, List<T>> consumer) {
        return PageResponse.of((Collection)consumer.apply(page.getRecords()), (int)((int)page.getTotal()), (int)((int)page.getSize()), (int)((int)page.getCurrent()));
    }

    public static List<OrderItem> initOrderBy(SortParam sortParam, SortParam ... defaultParams) {
        if (sortParam == null && ArrayUtil.isEmpty((Object[])defaultParams)) {
            return new ArrayList<OrderItem>();
        }
        ArrayList<OrderItem> orderItemList = new ArrayList<OrderItem>(6);
        if (sortParam != null && StrUtil.isNotBlank((CharSequence)sortParam.getSort())) {
            if ("descending".equals(sortParam.getOrder())) {
                orderItemList.add(OrderItem.desc((String)sortParam.getSort()));
            } else {
                orderItemList.add(OrderItem.asc((String)sortParam.getSort()));
            }
        } else if (ArrayUtil.isEmpty((Object[])defaultParams)) {
            orderItemList.add(OrderItem.desc((String)"id"));
        } else {
            Arrays.stream(defaultParams).forEach(defaultParam -> {
                if ("descending".equals(defaultParam.getOrder())) {
                    orderItemList.add(OrderItem.desc((String)defaultParam.getSort()));
                } else {
                    orderItemList.add(OrderItem.asc((String)defaultParam.getSort()));
                }
            });
        }
        return orderItemList;
    }

    public static <T> String getColumnName(SFunction<T, ?> func) {
        LambdaMeta lambdaMeta = LambdaUtils.extract(func);
        Map testMap = LambdaUtils.getColumnMap((Class)lambdaMeta.getInstantiatedClass());
        String fieldName = lambdaMeta.getImplMethodName().substring("get".length());
        fieldName = fieldName.replaceFirst("" + fieldName.charAt(0), ("" + fieldName.charAt(0)).toLowerCase());
        return ((ColumnCache)testMap.get(LambdaUtils.formatKey((String)fieldName))).getColumn();
    }
}

