/*
 * Decompiled with CFR 0.152.
 */
package top.charles7c.continew.starter.apidoc.autoconfigure;

import cn.hutool.core.map.MapUtil;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.CacheControl;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import top.charles7c.continew.starter.apidoc.autoconfigure.SpringDocExtensionProperties;
import top.charles7c.continew.starter.core.autoconfigure.project.ProjectProperties;
import top.charles7c.continew.starter.core.handler.GeneralPropertySourceFactory;

@EnableWebMvc
@AutoConfiguration
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={SpringDocExtensionProperties.class})
@PropertySource(value={"classpath:default-api-doc.yml"}, factory=GeneralPropertySourceFactory.class)
public class SpringDocAutoConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(SpringDocAutoConfiguration.class);

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"classpath:/"});
        registry.addResourceHandler(new String[]{"/doc.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"}).setCacheControl(CacheControl.maxAge((long)5L, (TimeUnit)TimeUnit.HOURS).cachePublic());
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenAPI openApi(ProjectProperties projectProperties, SpringDocExtensionProperties properties) {
        ProjectProperties.License license;
        Info info = new Info().title(String.format("%s %s", projectProperties.getName(), "API \u6587\u6863")).version(projectProperties.getVersion()).description(projectProperties.getDescription());
        ProjectProperties.Contact contact = projectProperties.getContact();
        if (null != contact) {
            info.contact(new Contact().name(contact.getName()).email(contact.getEmail()).url(contact.getUrl()));
        }
        if (null != (license = projectProperties.getLicense())) {
            info.license(new License().name(license.getName()).url(license.getUrl()));
        }
        OpenAPI openAPI = new OpenAPI();
        openAPI.info(info);
        Components components = properties.getComponents();
        if (null != components) {
            openAPI.components(components);
            Map securitySchemeMap = components.getSecuritySchemes();
            if (MapUtil.isNotEmpty((Map)securitySchemeMap)) {
                SecurityRequirement securityRequirement = new SecurityRequirement();
                List<String> list = securitySchemeMap.values().stream().map(SecurityScheme::getName).toList();
                list.forEach(arg_0 -> ((SecurityRequirement)securityRequirement).addList(arg_0));
                openAPI.addSecurityItem(securityRequirement);
            }
        }
        return openAPI;
    }

    @Bean
    @ConditionalOnMissingBean
    public GlobalOpenApiCustomizer globalOpenApiCustomizer(SpringDocExtensionProperties properties) {
        return openApi -> {
            if (null != openApi.getPaths()) {
                openApi.getPaths().forEach((s, pathItem) -> {
                    Components components = properties.getComponents();
                    if (null != components && MapUtil.isNotEmpty((Map)components.getSecuritySchemes())) {
                        Map securitySchemeMap = components.getSecuritySchemes();
                        pathItem.readOperations().forEach(operation -> {
                            SecurityRequirement securityRequirement = new SecurityRequirement();
                            List<String> list = securitySchemeMap.values().stream().map(SecurityScheme::getName).toList();
                            list.forEach(arg_0 -> ((SecurityRequirement)securityRequirement).addList(arg_0));
                            operation.addSecurityItem(securityRequirement);
                        });
                    }
                });
            }
        };
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[ContiNew Starter] - Auto Configuration 'ApiDoc' completed initialization.");
    }
}

