/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.security.password.autoconfigure;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.security.crypto.argon2.Argon2PasswordEncoder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.crypto.scrypt.SCryptPasswordEncoder;
import top.continew.starter.core.util.validate.CheckUtils;
import top.continew.starter.security.password.autoconfigure.PasswordEncoderProperties;

@AutoConfiguration
@EnableConfigurationProperties(value={PasswordEncoderProperties.class})
@ConditionalOnProperty(prefix="continew-starter.security.password", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class PasswordEncoderAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PasswordEncoderAutoConfiguration.class);
    private final PasswordEncoderProperties properties;

    public PasswordEncoderAutoConfiguration(PasswordEncoderProperties properties) {
        this.properties = properties;
    }

    @Bean
    public PasswordEncoder passwordEncoder(List<PasswordEncoder> passwordEncoderList) {
        String encodingId;
        HashMap<String, Object> encoders = new HashMap<String, Object>();
        encoders.put("bcrypt", new BCryptPasswordEncoder());
        encoders.put("pbkdf2", Pbkdf2PasswordEncoder.defaultsForSpringSecurity_v5_8());
        encoders.put("scrypt", SCryptPasswordEncoder.defaultsForSpringSecurity_v5_8());
        encoders.put("argon2", Argon2PasswordEncoder.defaultsForSpringSecurity_v5_8());
        if (CollUtil.isNotEmpty(passwordEncoderList)) {
            passwordEncoderList.forEach(passwordEncoder -> {
                String simpleName = passwordEncoder.getClass().getSimpleName();
                encoders.put(CharSequenceUtil.removeSuffix((CharSequence)simpleName, (CharSequence)"PasswordEncoder").toLowerCase(), passwordEncoder);
            });
        }
        CheckUtils.throwIf((!encoders.containsKey(encodingId = this.properties.getEncodingId()) ? 1 : 0) != 0, (String)"{} is not found in idToPasswordEncoder.", (Object[])new Object[]{encodingId});
        return new DelegatingPasswordEncoder(encodingId, encoders);
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[ContiNew Starter] - Auto Configuration 'Security-PasswordEncoder' completed initialization.");
    }
}

