/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.storage.local.autoconfigure;

import cn.hutool.core.text.CharSequenceUtil;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import top.continew.starter.storage.local.autoconfigure.LocalStorageProperties;

@EnableWebMvc
@AutoConfiguration
@EnableConfigurationProperties(value={LocalStorageProperties.class})
@ConditionalOnProperty(prefix="continew-starter.storage.local", name={"enabled"}, matchIfMissing=true)
public class LocalStorageAutoConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(LocalStorageAutoConfiguration.class);
    private final LocalStorageProperties properties;

    public LocalStorageAutoConfiguration(LocalStorageProperties properties) {
        this.properties = properties;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        Map<String, LocalStorageProperties.LocalStorageMapping> mappingMap = this.properties.getMapping();
        for (Map.Entry<String, LocalStorageProperties.LocalStorageMapping> mappingEntry : mappingMap.entrySet()) {
            LocalStorageProperties.LocalStorageMapping mapping = mappingEntry.getValue();
            String pathPattern = mapping.getPathPattern();
            String location = mapping.getLocation();
            if (CharSequenceUtil.isBlank((CharSequence)location)) {
                throw new IllegalArgumentException("Path pattern [%s] location is null.".formatted(pathPattern));
            }
            registry.addResourceHandler(new String[]{CharSequenceUtil.appendIfMissing((CharSequence)pathPattern, (CharSequence)"/**", (CharSequence[])new CharSequence[0])}).addResourceLocations(new String[]{!location.startsWith("file:") ? "file:%s".formatted(this.format(location)) : this.format(location)}).setCachePeriod(Integer.valueOf(0));
        }
    }

    private String format(String location) {
        return location.replace("\\", "/");
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[ContiNew Starter] - Auto Configuration 'Storage-Local' completed initialization.");
    }
}

