/*
 * Decompiled with CFR 0.152.
 */
package top.coos.extra.mail;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import top.coos.extra.mail.MailException;
import top.coos.util.ArrayUtil;

public class InternalMailUtil {
    public static InternetAddress[] parseAddressFromStrs(String[] addrStrs, Charset charset) {
        ArrayList<Object> resultList = new ArrayList<Object>(addrStrs.length);
        for (int i = 0; i < addrStrs.length; ++i) {
            Object[] addrs = InternalMailUtil.parseAddress(addrStrs[i], charset);
            if (!ArrayUtil.isNotEmpty((Object[])addrs)) continue;
            for (int j = 0; j < addrs.length; ++j) {
                resultList.add(addrs[j]);
            }
        }
        return resultList.toArray(new InternetAddress[resultList.size()]);
    }

    public static InternetAddress parseFirstAddress(String address, Charset charset) {
        Object[] internetAddresses = InternalMailUtil.parseAddress(address, charset);
        if (ArrayUtil.isEmpty((Object[])internetAddresses)) {
            try {
                return new InternetAddress(address);
            }
            catch (AddressException e) {
                throw new MailException(e);
            }
        }
        return internetAddresses[0];
    }

    public static InternetAddress[] parseAddress(String address, Charset charset) {
        Object[] addresses;
        try {
            addresses = InternetAddress.parse((String)address);
        }
        catch (AddressException e) {
            throw new MailException(e);
        }
        if (ArrayUtil.isNotEmpty((Object[])addresses)) {
            for (Object internetAddress : addresses) {
                try {
                    internetAddress.setPersonal(internetAddress.getPersonal(), charset.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new MailException(e);
                }
            }
        }
        return addresses;
    }

    public static String encodeText(String text, Charset charset) {
        try {
            return MimeUtility.encodeText((String)text, (String)charset.name(), null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return text;
        }
    }
}

