/*
 * Decompiled with CFR 0.152.
 */
package top.coos.poi.excel;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import top.coos.poi.excel.CellEditor;
import top.coos.poi.excel.CellUtil;
import top.coos.poi.excel.StyleSet;
import top.coos.util.StringUtil;

public class RowUtil {
    public static Row getOrCreateRow(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        if (null == row) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    public static List<Object> readRow(Row row, CellEditor cellEditor) {
        if (null == row) {
            return new ArrayList<Object>(0);
        }
        short length = row.getLastCellNum();
        if (length < 0) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> cellValues = new ArrayList<Object>(length);
        boolean isAllNull = true;
        for (short i = 0; i < length; i = (short)(i + 1)) {
            Object cellValue = CellUtil.getCellValue(row.getCell((int)i), cellEditor);
            isAllNull &= StringUtil.isEmptyIfStr((Object)cellValue);
            cellValues.add(cellValue);
        }
        if (isAllNull) {
            return new ArrayList<Object>(0);
        }
        return cellValues;
    }

    public static void writeRow(Row row, Iterable<?> rowData, StyleSet styleSet) {
        int i = 0;
        for (Object value : rowData) {
            Cell cell = row.createCell(i);
            CellUtil.setCellValue(cell, value, styleSet);
            ++i;
        }
    }
}

