/*
 * Decompiled with CFR 0.152.
 */
package top.coos.db.nosql.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.Closeable;
import java.util.ArrayList;
import org.bson.Document;
import org.slf4j.Logger;
import top.coos.core.exceptions.NotInitedException;
import top.coos.db.DbRuntimeException;
import top.coos.factory.LogFactory;
import top.coos.setting.Setting;
import top.coos.util.NetUtil;
import top.coos.util.StringUtil;

public class MongoDS
implements Closeable {
    private static final Logger log = LogFactory.get();
    public static final String MONGO_CONFIG_PATH = "config/mongo.setting";
    private Setting setting;
    private String[] groups;
    private ServerAddress serverAddress;
    private MongoClient mongo;

    public MongoDS(String host, int port) {
        this.serverAddress = this.createServerAddress(host, port);
        this.initSingle();
    }

    public MongoDS(Setting mongoSetting, String host, int port) {
        this.setting = mongoSetting;
        this.serverAddress = this.createServerAddress(host, port);
        this.initSingle();
    }

    public MongoDS(String ... groups) {
        this.groups = groups;
        this.init();
    }

    public MongoDS(Setting mongoSetting, String ... groups) {
        if (mongoSetting == null) {
            throw new DbRuntimeException("Mongo setting is null!");
        }
        this.setting = mongoSetting;
        this.groups = groups;
        this.init();
    }

    public void init() {
        if (this.groups != null && this.groups.length > 1) {
            this.initCloud();
        } else {
            this.initSingle();
        }
    }

    public synchronized void initSingle() {
        if (this.setting == null) {
            try {
                this.setting = new Setting(MONGO_CONFIG_PATH, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String group = "";
        if (this.serverAddress == null) {
            if (this.groups != null && this.groups.length == 1) {
                group = this.groups[0];
            }
            this.serverAddress = this.createServerAddress(group);
        }
        try {
            this.mongo = new MongoClient(this.serverAddress, this.buildMongoClientOptions(group));
        }
        catch (Exception e) {
            throw new DbRuntimeException(StringUtil.format((CharSequence)"Init MongoDB pool with connection to [{}] error!", (Object[])new Object[]{this.serverAddress}), (Throwable)e);
        }
        log.info("Init MongoDB pool with connection to [{}]", (Object)this.serverAddress);
    }

    public synchronized void initCloud() {
        if (this.groups == null || this.groups.length == 0) {
            throw new DbRuntimeException("Please give replication set groups!");
        }
        if (this.setting == null) {
            this.setting = new Setting(MONGO_CONFIG_PATH, true);
        }
        ArrayList<ServerAddress> addrList = new ArrayList<ServerAddress>();
        for (String group : this.groups) {
            addrList.add(this.createServerAddress(group));
        }
        try {
            this.mongo = new MongoClient(addrList, this.buildMongoClientOptions(""));
        }
        catch (Exception e) {
            log.error("Init MongoDB connection error!", (Throwable)e);
            return;
        }
        log.info("Init MongoDB cloud Set pool with connection to {}", addrList);
    }

    public void setSetting(Setting setting) {
        this.setting = setting;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    public MongoDatabase getDb(String dbName) {
        return this.mongo.getDatabase(dbName);
    }

    public MongoCollection<Document> getCollection(String dbName, String collectionName) {
        return this.getDb(dbName).getCollection(collectionName);
    }

    @Override
    public void close() {
        this.mongo.close();
    }

    private ServerAddress createServerAddress(String group) {
        String tmpHost;
        if (this.setting == null) {
            throw new DbRuntimeException(StringUtil.format((CharSequence)"Please indicate setting file or create default [{}], and define group [{}]", (Object[])new Object[]{MONGO_CONFIG_PATH, group}));
        }
        if (group == null) {
            group = "";
        }
        if (StringUtil.isBlank((CharSequence)(tmpHost = this.setting.getByGroup("host", group)))) {
            throw new NotInitedException("Host name is empy of group: " + group);
        }
        int defaultPort = this.setting.getInt("port", group, Integer.valueOf(27017));
        return new ServerAddress(NetUtil.buildInetSocketAddress((String)tmpHost, (int)defaultPort));
    }

    private ServerAddress createServerAddress(String host, int port) {
        return new ServerAddress(host, port);
    }

    private MongoClientOptions buildMongoClientOptions(String group) {
        return this.buildMongoClientOptions(MongoClientOptions.builder(), group).build();
    }

    private MongoClientOptions.Builder buildMongoClientOptions(MongoClientOptions.Builder builder, String group) {
        if (this.setting == null) {
            return builder;
        }
        group = group == null ? "" : group + ".";
        Integer connectionsPerHost = this.setting.getInt((Object)(group + "connectionsPerHost"));
        if (!StringUtil.isBlank((CharSequence)group) && connectionsPerHost == null) {
            connectionsPerHost = this.setting.getInt((Object)"connectionsPerHost");
        }
        if (connectionsPerHost != null) {
            builder.connectionsPerHost(connectionsPerHost.intValue());
            log.debug("MongoDB connectionsPerHost: {}", (Object)connectionsPerHost);
        }
        Integer threadsAllowedToBlockForConnectionMultiplier = this.setting.getInt((Object)(group + "threadsAllowedToBlockForConnectionMultiplier"));
        if (!StringUtil.isBlank((CharSequence)group) && threadsAllowedToBlockForConnectionMultiplier == null) {
            threadsAllowedToBlockForConnectionMultiplier = this.setting.getInt((Object)"threadsAllowedToBlockForConnectionMultiplier");
        }
        if (threadsAllowedToBlockForConnectionMultiplier != null) {
            builder.threadsAllowedToBlockForConnectionMultiplier(threadsAllowedToBlockForConnectionMultiplier.intValue());
            log.debug("MongoDB threadsAllowedToBlockForConnectionMultiplier: {}", (Object)threadsAllowedToBlockForConnectionMultiplier);
        }
        Integer connectTimeout = this.setting.getInt((Object)(group + "connectTimeout"));
        if (!StringUtil.isBlank((CharSequence)group) && connectTimeout == null) {
            this.setting.getInt((Object)"connectTimeout");
        }
        if (connectTimeout != null) {
            builder.connectTimeout(connectTimeout.intValue());
            log.debug("MongoDB connectTimeout: {}", (Object)connectTimeout);
        }
        Integer socketTimeout = this.setting.getInt((Object)(group + "socketTimeout"));
        if (!StringUtil.isBlank((CharSequence)group) && socketTimeout == null) {
            this.setting.getInt((Object)"socketTimeout");
        }
        if (socketTimeout != null) {
            builder.socketTimeout(socketTimeout.intValue());
            log.debug("MongoDB socketTimeout: {}", (Object)socketTimeout);
        }
        return builder;
    }
}

