/*
 * Decompiled with CFR 0.152.
 */
package top.coos.extra.es;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsResponse;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.open.OpenIndexAction;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import top.coos.extra.es.QueryBean;
import top.coos.util.StringUtil;

public class ESUtils {
    static Pattern badChars = Pattern.compile("\\s*[\\s~!\\^&\\(\\)\\-\\+:\\|\\\\\"\\\\$]+\\s*");

    private ESUtils() {
    }

    public static void close(Client client) {
        if (client != null) {
            try {
                client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            client = null;
        }
    }

    public static void flush(Client client, String indexName, String indexType) {
        try {
            client.admin().indices().flush(new FlushRequest(new String[]{indexName.toLowerCase(), indexType})).actionGet();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Client create(String clusterName, String ip, int port) throws UnknownHostException {
        Settings esSettings = Settings.builder().put("cluster.name", clusterName).put("client.transport.sniff", false).build();
        PreBuiltTransportClient client = new PreBuiltTransportClient(esSettings, new Class[0]);
        client.addTransportAddress(new TransportAddress(InetAddress.getByName(ip), port));
        return client;
    }

    public static boolean indicesExists(Client client, String indexName) {
        IndicesExistsRequest ier = new IndicesExistsRequest();
        ier.indices(new String[]{indexName.toLowerCase()});
        return ((IndicesExistsResponse)client.admin().indices().exists(ier).actionGet()).isExists();
    }

    public static boolean typesExists(Client client, String indexName, String indexType) {
        if (ESUtils.indicesExists(client, indexName)) {
            TypesExistsRequest ter = new TypesExistsRequest(new String[]{indexName.toLowerCase()}, new String[]{indexType});
            return ((TypesExistsResponse)client.admin().indices().typesExists(ter).actionGet()).isExists();
        }
        return false;
    }

    public static void deleteIndex(Client client, String indexName, String indexType, String id) {
        try {
            ((DeleteRequestBuilder)client.prepareDelete(indexName.toLowerCase(), indexType.toLowerCase(), id).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute().actionGet();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteIndex(Client client, String indexName) {
        IndicesExistsRequest ier = new IndicesExistsRequest();
        ier.indices(new String[]{indexName.toLowerCase()});
        boolean exists = ((IndicesExistsResponse)client.admin().indices().exists(ier).actionGet()).isExists();
        if (exists) {
            client.admin().indices().prepareDelete(new String[]{indexName.toLowerCase()}).execute().actionGet();
        }
    }

    public static SearchHits search(Client client, String indexName, List<String> indexTypes, QueryBuilder query, List<FieldSortBuilder> sortBuilders, int from, int size) throws NoNodeAvailableException {
        if (client == null) {
            return null;
        }
        indexName = indexName.toLowerCase();
        IndicesExistsRequest ier = new IndicesExistsRequest();
        ier.indices(new String[]{indexName});
        boolean exists = ((IndicesExistsResponse)client.admin().indices().exists(ier).actionGet()).isExists();
        if (!exists) {
            return null;
        }
        client.admin().indices().open(new OpenIndexRequest(new String[]{indexName})).actionGet();
        client.admin().indices().refresh(new RefreshRequest(new String[]{indexName})).actionGet();
        SearchRequestBuilder searchRequestBuilder = client.prepareSearch(new String[]{indexName});
        if (indexTypes != null && indexTypes.size() > 0) {
            String[] types = new String[indexTypes.size()];
            for (int i = 0; i < indexTypes.size(); ++i) {
                types[i] = indexTypes.get(i).toLowerCase();
            }
            searchRequestBuilder.setTypes(types);
        }
        searchRequestBuilder.setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        searchRequestBuilder.setFrom(from);
        searchRequestBuilder.setSize(size);
        searchRequestBuilder.setExplain(false);
        searchRequestBuilder.setQuery(query);
        if (sortBuilders != null && sortBuilders.size() > 0) {
            for (FieldSortBuilder sortBuilder : sortBuilders) {
                searchRequestBuilder.addSort((SortBuilder)sortBuilder);
            }
        }
        return ((SearchResponse)searchRequestBuilder.execute().actionGet()).getHits();
    }

    public static List<Map<String, Object>> queryAll(Client client, String indexName, String indexType, QueryBean bean) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ESUtils.queryFull(client, indexName, indexType, bean, result);
        return result;
    }

    public static void queryFull(Client client, String indexName, String indexType, QueryBean bean, List<Map<String, Object>> result) {
        List<Map<String, Object>> list = ESUtils.queryPage(client, indexName, indexType, bean);
        if (list != null) {
            result.addAll(list);
            if (list.size() == bean.getPagesize()) {
                bean.setCurrentpage(bean.getCurrentpage() + 1);
                ESUtils.queryFull(client, indexName, indexType, bean, result);
            }
        }
    }

    public static List<Map<String, Object>> queryPage(Client client, String indexName, String indexType, QueryBean bean) {
        if (!ESUtils.typesExists(client, indexName, indexType)) {
            return null;
        }
        SearchRequestBuilder builder = client.prepareSearch(new String[]{indexName});
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        builder.setTypes(new String[]{indexType});
        if (bean != null) {
            for (String key : bean.getWhere().keySet()) {
                Object value = bean.getWhere().get(key);
                if (value == null) continue;
                Object queryBuilder = null;
                queryBuilder = value instanceof String ? QueryBuilders.matchQuery((String)key, (Object)value) : QueryBuilders.termQuery((String)key, (Object)value);
                boolQueryBuilder.must((QueryBuilder)queryBuilder);
            }
            builder.setQuery((QueryBuilder)boolQueryBuilder);
            int pagesize = bean.getPagesize();
            int currentpage = bean.getCurrentpage();
            if (pagesize <= 0) {
                pagesize = 50;
            }
            if (currentpage <= 0) {
                currentpage = 1;
            }
            bean.setPagesize(pagesize);
            bean.setCurrentpage(currentpage);
            int from = pagesize * (currentpage - 1);
            builder.setFrom(from);
            builder.setSize(pagesize);
            if (bean.getSort() != null && bean.getSort().keySet().size() > 0) {
                for (String key : bean.getSort().keySet()) {
                    builder.addSort(key, bean.getSort().get(key));
                }
            }
        }
        SearchResponse response = (SearchResponse)builder.execute().actionGet();
        SearchHits searchHits = response.getHits();
        SearchHit[] hits = searchHits.getHits();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (SearchHit searchHit : hits) {
            Map source = searchHit.getSourceAsMap();
            list.add(source);
        }
        return list;
    }

    public static long queryCount(Client client, String indexName, String indexType, Map<String, Object> where) {
        if (!ESUtils.typesExists(client, indexName, indexType)) {
            return 0L;
        }
        SearchRequestBuilder searchBuilder = client.prepareSearch(new String[]{indexName}).setTypes(new String[]{indexType}).setSize(0);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (String key : where.keySet()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)key, (Object[])new Object[]{where.get(key)}));
        }
        searchBuilder.setQuery((QueryBuilder)boolQueryBuilder);
        SearchResponse response = (SearchResponse)searchBuilder.get();
        long length = response.getHits().getTotalHits();
        return length;
    }

    public static Map<String, Object> query(Client client, String indexName, String indexType, String id) {
        if (client == null) {
            return null;
        }
        if (StringUtil.isEmpty((CharSequence)indexName) || StringUtil.isEmpty((CharSequence)indexType) || StringUtil.isEmpty((CharSequence)id)) {
            return null;
        }
        IndicesExistsRequest ier = new IndicesExistsRequest();
        ier.indices(new String[]{indexName});
        boolean exists = ((IndicesExistsResponse)client.admin().indices().exists(ier).actionGet()).isExists();
        if (!exists) {
            return null;
        }
        client.admin().indices().open(new OpenIndexRequest(new String[]{indexName})).actionGet();
        client.admin().indices().refresh(new RefreshRequest(new String[]{indexName})).actionGet();
        GetRequest gr = new GetRequest(indexName, indexType, id);
        ActionFuture future = client.get(gr);
        GetResponse response = (GetResponse)future.actionGet();
        return ESUtils.swapResult(response);
    }

    public static boolean insertOrUpdate(Client client, String indexName, String indexType, String id, Map<String, Object> data) {
        try {
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
            jsonBuilder.startObject();
            for (String name : data.keySet()) {
                jsonBuilder.field(name, data.get(name));
            }
            jsonBuilder.endObject();
            IndexRequest indexRequest = new IndexRequest(indexName, indexType, id).source(jsonBuilder);
            UpdateRequest updateRequest = new UpdateRequest(indexName, indexType, id);
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            updateRequest.doc(jsonBuilder);
            updateRequest.upsert(indexRequest);
            client.update(updateRequest).actionGet();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean initIndex(Client client, String indexName, String indexType) throws Exception {
        if (StringUtil.isEmpty((CharSequence)indexName) || StringUtil.isEmpty((CharSequence)indexType)) {
            return false;
        }
        indexName = indexName.toLowerCase();
        indexType = indexType.toLowerCase();
        if (ESUtils.indicesExists(client, indexName)) {
            OpenIndexRequestBuilder openIndexBuilder = new OpenIndexRequestBuilder((ElasticsearchClient)client.admin().indices(), OpenIndexAction.INSTANCE);
            openIndexBuilder.setIndices(new String[]{indexName}).execute().actionGet();
        } else {
            client.admin().indices().prepareCreate(indexName).execute().actionGet();
        }
        TypesExistsRequest ter = new TypesExistsRequest(new String[]{indexName.toLowerCase()}, new String[]{indexType});
        boolean typeExists = ((TypesExistsResponse)client.admin().indices().typesExists(ter).actionGet()).isExists();
        if (typeExists) {
            return true;
        }
        PutMappingRequest mappingRequest = Requests.putMappingRequest((String[])new String[]{indexName}).type(indexType);
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        builder.startObject(indexName).startObject("analysis").startObject("analyzer").startObject("default").field("type", "keyword");
        mappingRequest.source(builder);
        PutMappingResponse response = (PutMappingResponse)client.admin().indices().putMapping(mappingRequest).actionGet();
        return response.isAcknowledged();
    }

    public static String preReadString(String read, int maxLength) {
        if (read == null || read.trim().length() == 0) {
            return "";
        }
        if ((read = read.trim()).length() <= maxLength) {
            return read;
        }
        return read.substring(0, maxLength);
    }

    public static List<Map<String, Object>> swapResult(SearchHits hits) {
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        if (hits == null || hits.getTotalHits() <= 0L) {
            return datas;
        }
        for (int i = 0; i < hits.getHits().length; ++i) {
            SearchHit hit = hits.getAt(i);
            Map rowData = hit.getSourceAsMap();
            rowData.put("_index", hit.getIndex());
            rowData.put("_type", hit.getType());
            rowData.put("_id", hit.getId());
            datas.add(rowData);
        }
        return datas;
    }

    public static Map<String, Object> swapResult(GetResponse response) {
        if (response == null || !response.isExists()) {
            return null;
        }
        Map rowData = response.getSourceAsMap();
        rowData.put("_index", response.getIndex());
        rowData.put("_type", response.getType());
        rowData.put("_id", response.getId());
        return rowData;
    }
}

