/*
 * Decompiled with CFR 0.152.
 */
package top.coos.extra.mail;

import java.io.File;
import java.util.Collection;
import java.util.List;
import top.coos.core.collection.CollUtil;
import top.coos.extra.mail.GlobalMailAccount;
import top.coos.extra.mail.Mail;
import top.coos.extra.mail.MailAccount;
import top.coos.util.StringUtil;

public class MailUtil {
    public static void sendText(String to, String subject, String content, File ... files) {
        MailUtil.send(to, subject, content, false, files);
    }

    public static void sendHtml(String to, String subject, String content, File ... files) {
        MailUtil.send(to, subject, content, true, files);
    }

    public static void send(String to, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(MailUtil.splitAddress(to), subject, content, isHtml, files);
    }

    public static void send(String to, String cc, String bcc, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(MailUtil.splitAddress(to), MailUtil.splitAddress(cc), MailUtil.splitAddress(bcc), subject, content, isHtml, files);
    }

    public static void sendText(Collection<String> tos, String subject, String content, File ... files) {
        MailUtil.send(tos, subject, content, false, files);
    }

    public static void sendHtml(Collection<String> tos, String subject, String content, File ... files) {
        MailUtil.send(tos, subject, content, true, files);
    }

    public static void send(Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(GlobalMailAccount.INSTANCE.getAccount(), tos, subject, content, isHtml, files);
    }

    public static void send(Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(GlobalMailAccount.INSTANCE.getAccount(), tos, ccs, bccs, subject, content, isHtml, files);
    }

    public static void send(MailAccount mailAccount, String to, String subject, String content, boolean isHtml, File ... files) {
        MailUtil.send(mailAccount, MailUtil.splitAddress(to), subject, content, isHtml, files);
    }

    public static void send(MailAccount mailAccount, Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        Mail.create(mailAccount).setTos(tos.toArray(new String[tos.size()])).setTitle(subject).setContent(content).setHtml(isHtml).setFiles(files).send();
    }

    public static void send(MailAccount mailAccount, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        Mail mail = Mail.create(mailAccount);
        if (CollUtil.isNotEmpty(ccs)) {
            mail.setCcs(ccs.toArray(new String[ccs.size()]));
        }
        if (CollUtil.isNotEmpty(bccs)) {
            mail.setBccs(bccs.toArray(new String[bccs.size()]));
        }
        mail.setTos(tos.toArray(new String[tos.size()]));
        mail.setTitle(subject);
        mail.setContent(content);
        mail.setHtml(isHtml);
        mail.setFiles(files);
        mail.send();
    }

    private static List<String> splitAddress(String addresses) {
        if (StringUtil.isBlank((CharSequence)addresses)) {
            return null;
        }
        List result = StringUtil.contains((CharSequence)addresses, (char)',') ? StringUtil.splitTrim((CharSequence)addresses, (char)',') : (StringUtil.contains((CharSequence)addresses, (char)';') ? StringUtil.splitTrim((CharSequence)addresses, (char)';') : CollUtil.newArrayList((Object[])new String[]{addresses}));
        return result;
    }
}

