/*
 * Decompiled with CFR 0.152.
 */
package top.coos.extra.servlet.multipart;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import top.coos.core.io.FileUtil;
import top.coos.core.io.IoUtil;
import top.coos.extra.servlet.multipart.MultipartRequestInputStream;
import top.coos.extra.servlet.multipart.UploadFileHeader;
import top.coos.extra.servlet.multipart.UploadSetting;
import top.coos.factory.LogFactory;
import top.coos.util.StringUtil;

public class UploadFile {
    private static final Logger log = LogFactory.get();
    private static final String TMP_FILE_PREFIX = "hutool-";
    private static final String TMP_FILE_SUFFIX = ".upload.tmp";
    private UploadFileHeader header;
    private UploadSetting setting;
    private int size = -1;
    private byte[] data;
    private File tempFile;

    public UploadFile(UploadFileHeader header, UploadSetting setting) {
        this.header = header;
        this.setting = setting;
    }

    public void delete() {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        if (this.data != null) {
            this.data = null;
        }
    }

    public File write(String destPath) throws IOException {
        if (this.data != null || this.tempFile != null) {
            return this.write(FileUtil.touch((String)destPath));
        }
        return null;
    }

    public File write(File destination) throws IOException {
        this.assertValid();
        if (destination.isDirectory()) {
            destination = new File(destination, this.header.getFileName());
        }
        if (this.data != null) {
            FileUtil.writeBytes((byte[])this.data, (File)destination);
            this.data = null;
        } else if (this.tempFile != null) {
            FileUtil.move((File)this.tempFile, (File)destination, (boolean)true);
        }
        return destination;
    }

    public byte[] getFileContent() throws IOException {
        this.assertValid();
        if (this.data != null) {
            return this.data;
        }
        if (this.tempFile != null) {
            return FileUtil.readBytes((File)this.tempFile);
        }
        return null;
    }

    public InputStream getFileInputStream() throws IOException {
        this.assertValid();
        if (this.data != null) {
            return new BufferedInputStream(new ByteArrayInputStream(this.data));
        }
        if (this.tempFile != null) {
            return new BufferedInputStream(new FileInputStream(this.tempFile));
        }
        return null;
    }

    public UploadFileHeader getHeader() {
        return this.header;
    }

    public String getFileName() {
        return this.header == null ? null : this.header.getFileName();
    }

    public int size() {
        return this.size;
    }

    public boolean isUploaded() {
        return this.size > 0;
    }

    public boolean isInMemory() {
        return this.data != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processStream(MultipartRequestInputStream input) throws IOException {
        if (!this.isAllowedExtension()) {
            log.debug("Forbidden uploaded file [{}]", (Object)this.getFileName());
            this.size = input.skipToBoundary();
            return false;
        }
        this.size = 0;
        int memoryThreshold = this.setting.memoryThreshold;
        if (memoryThreshold > 0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(memoryThreshold);
            int written = input.copy(baos, memoryThreshold);
            this.data = baos.toByteArray();
            if (written <= memoryThreshold) {
                this.size = this.data.length;
                return true;
            }
        }
        this.tempFile = FileUtil.createTempFile((String)TMP_FILE_PREFIX, (String)TMP_FILE_SUFFIX, (File)FileUtil.touch((String)this.setting.tmpUploadPath), (boolean)false);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        if (this.data != null) {
            this.size = this.data.length;
            out.write(this.data);
            this.data = null;
        }
        int maxFileSize = this.setting.maxFileSize;
        try {
            if (maxFileSize == -1) {
                this.size += input.copy(out);
                boolean bl = true;
                return bl;
            }
            this.size += input.copy(out, maxFileSize - this.size + 1);
            if (this.size > maxFileSize) {
                this.tempFile.delete();
                this.tempFile = null;
                log.debug("Upload file [{}] too big, file size > [{}]", (Object)this.getFileName(), (Object)maxFileSize);
                input.skipToBoundary();
                boolean bl = false;
                return bl;
            }
        }
        finally {
            IoUtil.close((Closeable)out);
        }
        return true;
    }

    private boolean isAllowedExtension() {
        String[] exts = this.setting.fileExts;
        boolean isAllow = this.setting.isAllowFileExts;
        if (exts == null || exts.length == 0) {
            return isAllow;
        }
        String fileNameExt = FileUtil.extName((String)this.getFileName());
        for (String fileExtension : this.setting.fileExts) {
            if (!fileNameExt.equalsIgnoreCase(fileExtension)) continue;
            return isAllow;
        }
        return !isAllow;
    }

    private void assertValid() throws IOException {
        if (!this.isUploaded()) {
            throw new IOException(StringUtil.format((CharSequence)"File [{}] upload fail", (Object[])new Object[]{this.getFileName()}));
        }
    }
}

