/*
 * Decompiled with CFR 0.152.
 */
package top.coos.extra.servlet.multipart;

import java.net.URL;
import org.slf4j.Logger;
import top.coos.factory.LogFactory;
import top.coos.setting.Setting;
import top.coos.util.URLUtil;

public class UploadSetting {
    private static final Logger log = LogFactory.get();
    public static final String DEFAULT_SETTING_PATH = "config/upload.setting";
    protected int maxFileSize = -1;
    protected int memoryThreshold = 8192;
    protected String tmpUploadPath;
    protected String[] fileExts;
    protected boolean isAllowFileExts = true;

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setMemoryThreshold(int memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    public String getTmpUploadPath() {
        return this.tmpUploadPath;
    }

    public void setTmpUploadPath(String tmpUploadPath) {
        this.tmpUploadPath = tmpUploadPath;
    }

    public String[] getFileExts() {
        return this.fileExts;
    }

    public void setFileExts(String[] fileExts) {
        this.fileExts = fileExts;
    }

    public boolean isAllowFileExts() {
        return this.isAllowFileExts;
    }

    public void setAllowFileExts(boolean isAllowFileExts) {
        this.isAllowFileExts = isAllowFileExts;
    }

    public void load() {
        this.load(DEFAULT_SETTING_PATH);
    }

    public synchronized void load(String settingPath) {
        URL url = URLUtil.getURL((String)settingPath);
        if (url == null) {
            log.info("Can not find Upload setting file [{}], use default setting.", (Object)settingPath);
            return;
        }
        Setting setting = new Setting(url, Setting.DEFAULT_CHARSET, true);
        this.maxFileSize = setting.getInt((Object)"file.size.max");
        this.memoryThreshold = setting.getInt((Object)"memory.threshold");
        this.tmpUploadPath = setting.getStr((Object)"tmp.upload.path");
        this.fileExts = setting.getStrings("file.exts");
        this.isAllowFileExts = setting.getBool((Object)"file.exts.allow");
    }
}

