/*
 * Decompiled with CFR 0.152.
 */
package top.coos.extra.ssh;

import com.jcraft.jsch.Session;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum JschSessionPool {
    INSTANCE;

    private Map<String, Session> sessionPool = new ConcurrentHashMap<String, Session>();

    public Session get(String key) {
        return this.sessionPool.get(key);
    }

    public void put(String key, Session session) {
        this.sessionPool.put(key, session);
    }

    public void close(String key) {
        Session session = this.sessionPool.get(key);
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
        this.sessionPool.remove(key);
    }

    public void closeAll() {
        Collection<Session> sessions = this.sessionPool.values();
        for (Session session : sessions) {
            if (!session.isConnected()) continue;
            session.disconnect();
        }
        this.sessionPool.clear();
    }
}

