/*
 * Decompiled with CFR 0.152.
 */
package top.coos.poi.excel;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import top.coos.core.bean.BeanUtil;
import top.coos.core.io.FileUtil;
import top.coos.core.io.IORuntimeException;
import top.coos.core.io.IoUtil;
import top.coos.core.lang.Assert;
import top.coos.core.map.MapUtil;
import top.coos.poi.excel.CellUtil;
import top.coos.poi.excel.ExcelUtil;
import top.coos.poi.excel.RowUtil;
import top.coos.poi.excel.StyleSet;
import top.coos.poi.excel.WorkbookUtil;

public class ExcelWriter
implements Closeable {
    private boolean isClosed;
    private Workbook workbook;
    private Sheet sheet;
    private File destFile;
    private AtomicInteger currentRow = new AtomicInteger(0);
    private Map<String, String> headerAlias;
    private StyleSet styleSet;

    public ExcelWriter() {
        this(false);
    }

    public ExcelWriter(boolean isXlsx) {
        this(WorkbookUtil.createBook(isXlsx ? ".xlsx" : ".xls"), null);
    }

    public ExcelWriter(String destFilePath) {
        this(destFilePath, null);
    }

    public ExcelWriter(String destFilePath, String sheetName) {
        this(FileUtil.file((String)destFilePath), sheetName);
    }

    public ExcelWriter(File destFile) {
        this(destFile, null);
    }

    public ExcelWriter(File destFile, String sheetName) {
        this(WorkbookUtil.createBook(destFile), sheetName);
        this.destFile = destFile;
    }

    public ExcelWriter(Workbook workbook, String sheetName) {
        this(ExcelUtil.getOrCreateSheet(workbook, sheetName));
    }

    public ExcelWriter(Sheet sheet) {
        this.workbook = sheet.getWorkbook();
        this.sheet = sheet;
        this.styleSet = new StyleSet(this.workbook);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public ExcelWriter autoSizeColumn(int columnIndex, boolean useMergedCells) {
        this.sheet.autoSizeColumn(columnIndex, useMergedCells);
        return this;
    }

    public StyleSet getStyleSet() {
        return this.styleSet;
    }

    public CellStyle getHeadCellStyle() {
        return this.styleSet.headCellStyle;
    }

    public CellStyle getCellStyle() {
        return this.styleSet.cellStyle;
    }

    public int getCurrentRow() {
        return this.currentRow.get();
    }

    public ExcelWriter setCurrentRow(int rowIndex) {
        this.currentRow.set(rowIndex);
        return this;
    }

    public ExcelWriter passCurrentRow() {
        this.currentRow.incrementAndGet();
        return this;
    }

    public ExcelWriter passRows(int rows) {
        this.currentRow.addAndGet(rows);
        return this;
    }

    public ExcelWriter resetRow() {
        this.currentRow.set(0);
        return this;
    }

    public ExcelWriter setOrCreateSheet(String sheetName) {
        this.sheet = ExcelUtil.getOrCreateSheet(this.workbook, sheetName);
        return this;
    }

    public ExcelWriter setDestFile(File destFile) {
        this.destFile = destFile;
        return this;
    }

    public ExcelWriter setHeaderAlias(Map<String, String> headerAlias) {
        this.headerAlias = headerAlias;
        return this;
    }

    public ExcelWriter setColumnWidth(int columnIndex, int width) {
        if (columnIndex < 0) {
            this.sheet.setDefaultColumnWidth(width);
        } else {
            this.sheet.setColumnWidth(columnIndex, width * 256);
        }
        return this;
    }

    public ExcelWriter setRowHeight(int rownum, int height) {
        if (rownum < 0) {
            this.sheet.setDefaultRowHeightInPoints((float)height);
        } else {
            this.sheet.getRow(rownum).setHeightInPoints((float)height);
        }
        return this;
    }

    public ExcelWriter merge(int lastColumn) {
        return this.merge(lastColumn, null);
    }

    public ExcelWriter merge(int lastColumn, Object content) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        int rowIndex = this.currentRow.get();
        Cell cell = this.sheet.createRow(rowIndex).createCell(0);
        if (null != this.styleSet.headCellStyle) {
            cell.setCellStyle(this.styleSet.headCellStyle);
            CellUtil.mergingCells(this.sheet, rowIndex, rowIndex, 0, lastColumn, this.styleSet.headCellStyle);
        }
        if (null != content) {
            CellUtil.setCellValue(cell, content, this.styleSet);
            this.currentRow.incrementAndGet();
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        int index = 0;
        for (Object object : data) {
            if (object instanceof Iterable) {
                this.writeRow((Iterable)object);
            } else if (object instanceof Map) {
                this.writeRows((Map)object, 0 == index);
            } else {
                if (!BeanUtil.isBean(object.getClass())) break;
                this.writeRows(BeanUtil.beanToMap(object), 0 == index);
            }
            ++index;
        }
        if (0 == index) {
            this.writeRow(data);
        }
        return this;
    }

    public <T> ExcelWriter write(Iterable<T> data, Comparator<String> comparator) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        boolean isFirstRow = true;
        for (T t : data) {
            Map map;
            if (t instanceof Map) {
                map = new TreeMap(comparator);
                map.putAll((Map)t);
            } else {
                map = BeanUtil.beanToMap(t, new TreeMap(comparator), (boolean)false, (boolean)false);
            }
            this.writeRows(map, isFirstRow);
            if (!isFirstRow) continue;
            isFirstRow = false;
        }
        return this;
    }

    public ExcelWriter writeHeadRow(Iterable<?> rowData) {
        RowUtil.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), rowData, this.styleSet);
        return this;
    }

    public ExcelWriter writeRow(Iterable<?> rowData) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        RowUtil.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), rowData, this.styleSet);
        return this;
    }

    public ExcelWriter writeRows(Map<?, ?> rowMap, boolean isWriteKeys) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        if (isWriteKeys) {
            this.writeHeadRow(this.aliasHeader(rowMap.keySet()));
        }
        this.writeRow(rowMap.values());
        return this;
    }

    public ExcelWriter writeCellValue(int x, int y, Object value) {
        Cell cell = this.getOrCreateCell(x, y);
        CellUtil.setCellValue(cell, value, this.styleSet);
        return this;
    }

    public Cell getOrCreateCell(int x, int y) {
        Row row = RowUtil.getOrCreateRow(this.sheet, y);
        return CellUtil.getOrCreateCell(row, x);
    }

    public CellStyle createStyleForCell(int x, int y) {
        CellStyle cellStyle = this.workbook.createCellStyle();
        Cell cell = this.getOrCreateCell(x, y);
        cell.setCellStyle(this.workbook.createCellStyle());
        return cellStyle;
    }

    public ExcelWriter flush() throws IORuntimeException {
        return this.flush(this.destFile);
    }

    public ExcelWriter flush(File destFile) throws IORuntimeException {
        Assert.notNull((Object)destFile, (String)"[destFile] is null, and you must call setDestFile(File) first or call flush(OutputStream).", (Object[])new Object[0]);
        BufferedOutputStream out = null;
        try {
            out = FileUtil.getOutputStream((File)destFile);
            this.flush(out);
        }
        finally {
            IoUtil.close((Closeable)out);
        }
        return this;
    }

    public ExcelWriter flush(OutputStream out) throws IORuntimeException {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        try {
            this.workbook.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    @Override
    public void close() {
        if (null != this.destFile) {
            this.flush();
        }
        IoUtil.close((Closeable)this.workbook);
        this.currentRow = null;
        this.styleSet = null;
        this.sheet = null;
        this.workbook = null;
        this.isClosed = true;
    }

    private Collection<?> aliasHeader(Collection<?> keys) {
        if (MapUtil.isEmpty(this.headerAlias)) {
            return keys;
        }
        ArrayList alias = new ArrayList();
        for (Object key : keys) {
            String aliasName = this.headerAlias.get(key);
            alias.add(null == aliasName ? key : aliasName);
        }
        return alias;
    }
}

