/*
 * Decompiled with CFR 0.152.
 */
package top.coos.poi.excel.sax;

import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import top.coos.poi.excel.sax.CellDataType;
import top.coos.util.StringUtil;

public class ExcelSaxUtil {
    public static final char CELL_FILL_CHAR = '@';
    public static final int MAX_CELL_BIT = 3;

    public static String getDataValue(CellDataType cellDataType, String value, SharedStringsTable sharedStringsTable, int numFmtIndex, String numFmtString) {
        String thisStr;
        if (null == value) {
            return null;
        }
        switch (cellDataType) {
            case BOOL: {
                char first = value.charAt(0);
                thisStr = first == '0' ? "FALSE" : "TRUE";
                break;
            }
            case ERROR: {
                thisStr = StringUtil.format((CharSequence)"\\\"ERROR: {} ", (Object[])new Object[]{value});
                break;
            }
            case FORMULA: {
                thisStr = StringUtil.format((CharSequence)"\"{}\"", (Object[])new Object[]{value});
                break;
            }
            case INLINESTR: {
                thisStr = new XSSFRichTextString(value.toString()).toString();
                break;
            }
            case SSTINDEX: {
                try {
                    int index = Integer.parseInt(value);
                    thisStr = new XSSFRichTextString(sharedStringsTable.getEntryAt(index)).getString();
                }
                catch (NumberFormatException e) {
                    thisStr = value;
                }
                break;
            }
            case NUMBER: {
                thisStr = ExcelSaxUtil.formatCellContent(value, numFmtIndex, numFmtString);
                thisStr = thisStr.replace("_", "").trim();
                break;
            }
            case DATE: {
                thisStr = ExcelSaxUtil.formatCellContent(value, numFmtIndex, numFmtString);
                break;
            }
            default: {
                thisStr = "";
            }
        }
        return thisStr;
    }

    public static String formatCellContent(String value, int numFmtIndex, String numFmtString) {
        if (null != numFmtString) {
            try {
                value = new DataFormatter().formatRawCellContents(Double.parseDouble(value), numFmtIndex, numFmtString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static int countNullCell(String preRef, String ref) {
        String preXfd = preRef.replaceAll("\\d+", "");
        String xfd = ref.replaceAll("\\d+", "");
        preXfd = StringUtil.fillBefore((String)preXfd, (char)'@', (int)3);
        xfd = StringUtil.fillBefore((String)xfd, (char)'@', (int)3);
        char[] preLetter = preXfd.toCharArray();
        char[] letter = xfd.toCharArray();
        int res = (letter[0] - preLetter[0]) * 26 * 26 + (letter[1] - preLetter[1]) * 26 + (letter[2] - preLetter[2]);
        return res - 1;
    }
}

