package top.crystalx.sms.models.R;


/**
 * @author SIYE
 */
public class SendResult {
    /**
     * 发送结果
     */
    private String message;

    /**
     * 发送状态
     */
    private int statusCode;

    /**
     * 接收短信号码
     */
    private String phoneNumber;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final SendResult result;

        public Builder() {
            this.result = new SendResult();
        }

        public Builder message(String message) {
            this.result.message = message;
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.result.statusCode = statusCode;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.result.phoneNumber = phoneNumber;
            return this;
        }

        public SendResult build() {
            return this.result;
        }
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Override
    public String toString() {
        return "SendResult{" +
                "message='" + message + '\'' +
                ", statusCode=" + statusCode +
                ", phoneNumber='" + phoneNumber + '\'' +
                '}';
    }
}
