package top.crystalx.sms.models.R;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author SIYE
 */
public class SmsResponse {
    /**
     * 签名名称
     */
    private String signName;

    /**
     * 模板参数
     */
    private Map<String, String> params;

    /**
     * 发送结果
     */
    public List<SendResult> sendResults = new ArrayList<>();


    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final SmsResponse response;

        public Builder() {
            this.response = new SmsResponse();
        }

        public Builder signName(String signName) {
            this.response.signName = signName;
            return this;
        }

        public Builder sendResults(SendResult sendResult) {
            this.response.sendResults.add(sendResult);
            return this;
        }

        public Builder sendResults(List<SendResult> sendResults) {
            this.response.sendResults.addAll(sendResults);
            return this;
        }

        public Builder params(Map<String, String> params) {
            this.response.params = params;
            return this;
        }


        public SmsResponse build() {
            return this.response;
        }
    }

    public String getSignName() {
        return signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }



    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public List<SendResult> getSendResults() {
        return sendResults;
    }

    public void setSendResults(List<SendResult> sendResults) {
        this.sendResults = sendResults;
    }

    @Override
    public String toString() {
        return "SmsResponse{" +
                "signName='" + signName + '\'' +
                ", params=" + params +
                ", sendResults=" + sendResults +
                '}';
    }
}
