package top.crystalx.sms.models.aliyun;

import top.crystalx.sms.core.BaseSmsModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author SIYE
 */
public class AliYunBatchModel extends BaseSmsModel {
    /**
     * 签名名称
     */
    private String signName;

    /**
     * 模板编码
     */
    private String templateCode;

    /**
     * 批量发送电话
     */
    private List<String> phoneNumbers = new ArrayList<>();

    /**
     * 模板参数
     */
    private Map<String, String> params;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final AliYunBatchModel model;

        public Builder() {
            this.model = new AliYunBatchModel();
        }

        public Builder signName(String signName) {
            this.model.signName = signName;
            return this;
        }


        public Builder templateCode(String templateCode) {
            this.model.templateCode = templateCode;
            return this;
        }

        public Builder phoneNumbers(String phoneNumber) {
            this.model.phoneNumbers.add(phoneNumber);
            return this;
        }

        public Builder phoneNumbers(List<String> phoneNumbers) {
            this.model.phoneNumbers.addAll(phoneNumbers);
            return this;
        }

        public Builder params(Map<String, String> params) {
            this.model.params = params;
            return this;
        }

        public AliYunBatchModel build() {
            return this.model;
        }
    }

    public String getSignName() {
        return signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public List<String> getPhoneNumbers() {
        return phoneNumbers;
    }

    public void setPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }
}
