package top.crystalx.sms.models.aliyun;

import top.crystalx.sms.core.BaseSmsModel;

import java.util.HashMap;
import java.util.Map;


/**
 * @author SIYE
 */
public class AliYunModel extends BaseSmsModel {
    /**
     * 签名名称
     */
    private String signName;

    /**
     * 模板编码
     */
    private String templateCode;

    /**
     * 接收短信电话
     */
    private String phoneNumber;

    /**
     * 模板参数
     */
    private Map<String, String> params = new HashMap<>();


    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final AliYunModel model;

        public Builder() {
            this.model = new AliYunModel();
        }

        public Builder signName(String signName) {
            this.model.signName = signName;
            return this;
        }

        public Builder templateCode(String templateCode) {
            this.model.templateCode = templateCode;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.model.phoneNumber = phoneNumber;
            return this;
        }

        public Builder params(Map<String, String> params) {
            this.model.params = params;
            return this;
        }
        public AliYunModel build() {
            return this.model;
        }
    }

    public String getSignName() {
        return signName;
    }


    public void setSignName(String signName) {
        this.signName = signName;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }
}
