package top.crystalx.sms.models.tencent;

import top.crystalx.sms.core.BaseSmsModel;

import java.util.*;

/**
 * @author SIYE
 */
public class TencentModel extends BaseSmsModel {
    /**
     * 短信 SdkAppId
     */
    private String sdkAppId;

    /**
     * 短信签名内容
     */
    private String signName;

    /**
     * 模板ID
     */
    private String templateId;

    /**
     * 模板参数
     */
    private List<String> params = new ArrayList<>();

    /**
     * 下发手机号码，采用 E.164 标准，格式为+[国家或地区码][手机号]
     */
    private List<String> phoneNumbers = new ArrayList<>();

    /**
     * 用户的 session 内容，可以携带用户侧 ID 等上下文信息，server 会原样返回。
     */
    private String sessionContext;

    /**
     * 短信码号扩展号
     */
    private String extendCode;

    /**
     * 国内短信无需填写该项；国际/港澳台短信已申请独立 SenderId 需要填写该字段，默认使用公共 SenderId，无需填写该字段。
     */
    private String senderId;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final TencentModel model;

        public Builder() {
            this.model = new TencentModel();
        }

        public Builder sdkAppId(String sdkAppId) {
            this.model.sdkAppId = sdkAppId;
            return this;
        }

        public Builder signName(String signName) {
            this.model.signName = signName;
            return this;
        }

        public Builder templateId(String templateId) {
            this.model.templateId = templateId;
            return this;
        }

        public Builder param(String params) {
            this.model.params.add(params);
            return this;
        }

        public Builder params(List<String> params) {
            this.model.params.addAll(params);
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.model.phoneNumbers.add(phoneNumber);
            return this;
        }

        public Builder phoneNumbers(List<String> phoneNumbers) {
            this.model.phoneNumbers.addAll(phoneNumbers);
            return this;
        }

        public Builder sessionContext(String sessionContext) {
            this.model.sessionContext = sessionContext;
            return this;
        }

        public Builder extendCode(String extendCode) {
            this.model.extendCode = extendCode;
            return this;
        }

        public Builder senderId(String senderId) {
            this.model.senderId = senderId;
            return this;
        }

        public TencentModel build() {
            return this.model;
        }
    }


    public String getSdkAppId() {
        return sdkAppId;
    }

    public void setSdkAppId(String sdkAppId) {
        this.sdkAppId = sdkAppId;
    }

    public String getSignName() {
        return signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public Map<String, String> getParamsMap() {
        Map<String, String> params = new HashMap<>();
        for (int i = 0; i < this.params.size(); i++) {
            params.put(String.valueOf(i + 1), this.params.get(i));
        }
        return params;
    }

    public List<String> getParams() {
        return this.params;
    }

    public void setParams(List<String> params) {
        this.params = params;
    }

    public List<String> getPhoneNumbers() {
        return phoneNumbers;
    }

    public void setPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public String getSessionContext() {
        return sessionContext;
    }

    public void setSessionContext(String sessionContext) {
        this.sessionContext = sessionContext;
    }

    public String getExtendCode() {
        return extendCode;
    }

    public void setExtendCode(String extendCode) {
        this.extendCode = extendCode;
    }

    public String getSenderId() {
        return senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }
}
