package top.crystalx.sms.props;

import org.springframework.beans.factory.annotation.Value;
import top.crystalx.sms.constant.AliYunEndpoint;
import top.crystalx.sms.core.BaseSmsProperty;

/**
 * @author SIYE
 */
public class AliYunProperty extends BaseSmsProperty {

    /**
     * 阿里云 accessKeyId 默认获取配置文件
     */
    @Value("${crystal.sms.alibaba.accessKeyId}")
    private String accessKeyId;

    /**
     * 阿里云 accessKeySecret 默认获取配置文件
     */
    @Value("${crystal.sms.alibaba.accessKeySecret}")
    private String accessKeySecret;

    /**
     * 阿里云 securityToken 默认获取配置文件
     */
    @Value("${crystal.sms.alibaba.securityToken}")
    private String securityToken;

    /**
     * 阿里云 endpoint 信息
     */
    private AliYunEndpoint endpoint = AliYunEndpoint.SOUTH_WEST_1;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final AliYunProperty model;

        public Builder() {
            this.model = new AliYunProperty();
        }

        public Builder accessKeyId(String accessKeyId) {
            this.model.accessKeyId = accessKeyId;
            return this;
        }

        public Builder accessKeySecret(String accessKeySecret) {
            this.model.accessKeySecret = accessKeySecret;
            return this;
        }

        public Builder securityToken(String securityToken) {
            this.model.securityToken = securityToken;
            return this;
        }

        public Builder endpoint(AliYunEndpoint endpoint) {
            this.model.endpoint = endpoint;
            return this;
        }

        public AliYunProperty build() {
            return this.model;
        }
    }

    public String getAccessKeyId() {
        return accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getSecurityToken() {
        return securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public AliYunEndpoint getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(AliYunEndpoint endpoint) {
        this.endpoint = endpoint;
    }
}
