package top.crystalx.sms.props;

import top.crystalx.sms.constant.TencentEndpoint;
import top.crystalx.sms.core.BaseSmsProperty;

/**
 * @author SIYE
 */
public class TencentProperty extends BaseSmsProperty {

    /**
     * 腾讯云 secretId
     */
    private String secretId;

    /**
     * 腾讯云 secretKey
     */
    private String secretKey;

    /**
     * 腾讯云 endpoint
     */
    private TencentEndpoint endpoint = TencentEndpoint.SOUTH;

    /**
     * 请求方法
     */
    private String method = "POST";

    /**
     * 超时时间
     */
    private int connectTimeout = 60;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final TencentProperty config;

        public Builder() {
            this.config = new TencentProperty();
        }

        public Builder secretId(String secretId) {
            this.config.secretId = secretId;
            return this;
        }

        public Builder secretKey(String secretKey) {
            this.config.secretKey = secretKey;
            return this;
        }

        public Builder endpoint(TencentEndpoint endpoint) {
            this.config.endpoint = endpoint;
            return this;
        }

        public Builder method(String method) {
            this.config.method = method;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.config.connectTimeout = connectTimeout;
            return this;
        }

        public TencentProperty build() {
            return this.config;
        }
    }

    public String getSecretId() {
        return secretId;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public TencentEndpoint getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(TencentEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public int getConnectTimeout() {
        return connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }
}
